/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.serializer;

import java.io.IOException;
import net.oschina.j2cache.serializer.FstSerializer;
import net.oschina.j2cache.serializer.Serializer;
import net.oschina.j2cache.serializer.SerializerTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

public class FstSnappySerializer<T>
implements Serializer<T> {
    private static final Logger log = LoggerFactory.getLogger(FstSnappySerializer.class);
    private final Serializer<T> inner;

    public FstSnappySerializer() {
        this(new FstSerializer());
    }

    public FstSnappySerializer(Serializer<T> innerSerializer) {
        this.inner = innerSerializer;
    }

    @Override
    public byte[] serialize(T value) {
        try {
            return Snappy.compress((byte[])this.inner.serialize(value));
        }
        catch (IOException e) {
            log.warn("\u5e8f\u5217\u5316\u5931\u8d25, value = " + value, (Throwable)e);
            return EMPTY_BYTES;
        }
    }

    @Override
    public T deserialize(byte[] bytes) {
        if (SerializerTools.isEmpty(bytes)) {
            return null;
        }
        try {
            return this.inner.deserialize(Snappy.uncompress((byte[])bytes));
        }
        catch (IOException e) {
            log.warn("\u53cd\u5e8f\u5217\u5316 bytes \u5931\u8d25.", (Throwable)e);
            return null;
        }
    }
}

