/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.oschina.j2cache.serializer.Serializer;
import net.oschina.j2cache.serializer.SerializerTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkSerializer<T>
implements Serializer<T> {
    private static final Logger log = LoggerFactory.getLogger(JdkSerializer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serialize(T value) {
        if (value == null) {
            return EMPTY_BYTES;
        }
        ByteArrayOutputStream os = null;
        ObjectOutputStream oos = null;
        try {
            os = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(os);
            oos.writeObject(value);
            oos.flush();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.warn("\u5e8f\u5217\u5316\u5931\u8d25, value = " + value, (Throwable)e);
            byte[] byArray = EMPTY_BYTES;
            return byArray;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {
                log.warn("\u5e8f\u5217\u5316\u5931\u8d25, value = " + value, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T deserialize(byte[] bytes) {
        if (SerializerTools.isEmpty(bytes)) {
            return null;
        }
        ByteArrayInputStream is = null;
        ObjectInputStream ois = null;
        try {
            is = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(is);
            Object object = ois.readObject();
            return (T)object;
        }
        catch (Exception e) {
            log.warn("\u53cd\u5e8f\u5217\u5316 bytes \u5931\u8d25.", (Throwable)e);
            T t = null;
            return t;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {
                log.warn("\u53cd\u5e8f\u5217\u5316 bytes \u5931\u8d25.", (Throwable)e);
            }
        }
    }
}

