/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.serializer;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.oschina.j2cache.serializer.FstSnappySerializer;
import net.oschina.j2cache.serializer.Serializer;
import net.oschina.j2cache.serializer.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerTools {
    private static final Logger log = LoggerFactory.getLogger(SerializerTools.class);
    private static final StringSerializer keySerializer = new StringSerializer();
    private static final FstSnappySerializer<Object> valueSerializer = new FstSnappySerializer();

    static boolean isEmpty(byte[] data) {
        return data == null || data.length == 0;
    }

    public static byte[] serializeKey(Object key) {
        return keySerializer.serialize(key.toString());
    }

    public static Object deserializeKey(byte[] key) {
        return keySerializer.deserialize(key);
    }

    public static byte[] serializeValue(Object value) {
        try {
            return valueSerializer.serialize(value);
        }
        catch (Exception e) {
            log.warn("value \u5e8f\u5217\u5316\u5931\u8d25. value = {}", value, (Object)e);
            return null;
        }
    }

    public static Object deserializeValue(byte[] value) {
        return valueSerializer.deserialize(value);
    }

    private static <T extends Collection<Object>> T deserializeValues(Collection<byte[]> values, Class<T> clazz, Serializer<Object> serializer) {
        if (values == null) {
            return null;
        }
        int valueCount = values.size();
        AbstractCollection _values = List.class.isAssignableFrom(clazz) ? new ArrayList(valueCount) : new HashSet(valueCount);
        for (byte[] bs : values) {
            _values.add(serializer.deserialize(bs));
        }
        return (T)_values;
    }
}

