/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.store.ehcache;

import java.util.Collection;
import java.util.List;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

public class EhCache
implements Cache,
CacheEventListener {
    private final net.sf.ehcache.Cache cache;
    private final CacheExpiredListener listener;

    public EhCache(net.sf.ehcache.Cache cache, CacheExpiredListener listener) {
        this.cache = cache;
        this.cache.getCacheEventNotificationService().registerListener((CacheEventListener)this);
        this.listener = listener;
    }

    @Override
    public Object get(Object key) throws CacheException {
        try {
            if (key == null) {
                return null;
            }
            Element element = this.cache.get(key);
            if (element != null) {
                return element.getObjectValue();
            }
            return null;
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void put(Object key, Object value) throws CacheException {
        try {
            Element element = new Element(key, value);
            this.cache.put(element);
        }
        catch (IllegalArgumentException | IllegalStateException | net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void evict(Object key) throws CacheException {
        try {
            this.cache.remove(key);
        }
        catch (IllegalStateException | net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void evict(List keys) throws CacheException {
        this.cache.removeAll((Collection)keys);
    }

    @Override
    public List keys() throws CacheException {
        return this.cache.getKeys();
    }

    @Override
    public void clear() throws CacheException {
        try {
            this.cache.removeAll();
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void destroy() throws CacheException {
        try {
            this.cache.getCacheManager().removeCache(this.cache.getName());
        }
        catch (IllegalStateException | net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    public void notifyElementRemoved(Ehcache ehcache, Element element) throws net.sf.ehcache.CacheException {
    }

    public void notifyElementPut(Ehcache ehcache, Element element) throws net.sf.ehcache.CacheException {
    }

    public void notifyElementUpdated(Ehcache ehcache, Element element) throws net.sf.ehcache.CacheException {
    }

    public void notifyElementExpired(Ehcache ehcache, Element element) {
        if (this.listener != null) {
            this.listener.notifyElementExpired(ehcache.getName(), element.getObjectKey());
        }
    }

    public void notifyElementEvicted(Ehcache ehcache, Element element) {
    }

    public void notifyRemoveAll(Ehcache ehcache) {
    }

    public void dispose() {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

