/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.store.ehcache;

import java.net.URL;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.store.ehcache.EhCache;
import net.sf.ehcache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheProvider
implements CacheProvider {
    private static final Logger logger = LoggerFactory.getLogger(EhCacheProvider.class);
    private String config_path = "/ehcache.xml";
    private CacheManager ehcacheManager;
    private ConcurrentHashMap<String, EhCache> cacheInstances;

    @Override
    public String name() {
        return "ehcache";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache buildCache(String regionName, boolean autoCreate, CacheExpiredListener listener) throws CacheException {
        EhCache ehCache = this.cacheInstances.get(this.name());
        if (ehCache == null && autoCreate) {
            try {
                ConcurrentHashMap<String, EhCache> concurrentHashMap = this.cacheInstances;
                synchronized (concurrentHashMap) {
                    ehCache = this.cacheInstances.get(regionName);
                    if (ehCache == null) {
                        net.sf.ehcache.Cache cache = this.ehcacheManager.getCache(regionName);
                        if (cache == null) {
                            logger.warn("\u627e\u4e0d\u5230\u7f13\u5b58\u914d\u7f6e\u7684 {}\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e", (Object)regionName);
                            this.ehcacheManager.addCache(regionName);
                            cache = this.ehcacheManager.getCache(regionName);
                            logger.debug("start EhCache region : {}", (Object)regionName);
                        }
                        ehCache = new EhCache(cache, listener);
                        this.cacheInstances.put(regionName, ehCache);
                    }
                }
            }
            catch (net.sf.ehcache.CacheException e) {
                throw new CacheException(e);
            }
        }
        return ehCache;
    }

    @Override
    public void start(Properties props) throws CacheException {
        if (this.ehcacheManager != null) {
            logger.warn("EhCache \u5df2\u7ecf\u542f\u52a8");
            return;
        }
        URL xml = this.getClass().getClassLoader().getParent().getResource(this.config_path);
        if (xml == null) {
            xml = this.getClass().getResource(this.config_path);
        }
        if (xml == null) {
            throw new CacheException(String.format("\u6ca1\u6709\u627e\u5230EhCache\u7684\u914d\u7f6e\u6587\u4ef6 : %s", this.config_path));
        }
        this.ehcacheManager = new CacheManager();
        this.cacheInstances = new ConcurrentHashMap();
    }

    @Override
    public void start(String confFilePath) throws CacheException {
        if (this.ehcacheManager != null) {
            logger.warn("EhCache \u5df2\u7ecf\u542f\u52a8");
            return;
        }
        URL xml = this.getClass().getClassLoader().getParent().getResource(confFilePath);
        if (xml == null) {
            xml = this.getClass().getResource(confFilePath);
        }
        if (xml == null) {
            throw new CacheException(String.format("\u6ca1\u6709\u627e\u5230EhCache\u7684\u914d\u7f6e\u6587\u4ef6 : %s", confFilePath));
        }
        this.config_path = confFilePath;
        this.ehcacheManager = new CacheManager(xml);
        this.cacheInstances = new ConcurrentHashMap();
    }

    @Override
    public void stop() {
        if (this.ehcacheManager != null) {
            this.ehcacheManager.shutdown();
            this.ehcacheManager = null;
        }
    }
}

