/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.store.redis;

import java.util.ArrayList;
import java.util.List;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.serializer.SerializerTools;
import net.oschina.j2cache.store.redis.RedisCacheProvider;
import net.oschina.j2cache.utils.CacheCodeUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;

public class RedisCache
implements Cache {
    private String region;

    public RedisCache(String region) {
        this.region = region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) throws CacheException {
        Object result = null;
        Jedis jedis = RedisCacheProvider.getResource();
        if (jedis == null || StringUtils.isEmpty((Object)key)) {
            return null;
        }
        try {
            byte[] b = jedis.get(SerializerTools.serializeKey(CacheCodeUtils.createRedisKey(this.region, key)));
            if (b != null) {
                result = SerializerTools.deserializeValue(b);
            }
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                this.evict(key);
            }
        }
        finally {
            RedisCacheProvider.returnResource(jedis);
        }
        return result;
    }

    @Override
    public void put(Object key, Object value) throws CacheException {
        if (value == null) {
            this.evict(key);
        } else {
            Jedis jedis = RedisCacheProvider.getResource();
            try {
                jedis.set(SerializerTools.serializeKey(CacheCodeUtils.createRedisKey(this.region, key)), SerializerTools.serializeValue(value));
            }
            catch (Exception e) {
                throw new CacheException(e);
            }
            finally {
                RedisCacheProvider.returnResource(jedis);
            }
        }
    }

    @Override
    public void evict(Object key) throws CacheException {
        Jedis jedis = RedisCacheProvider.getResource();
        try {
            jedis.del(SerializerTools.serializeKey(CacheCodeUtils.createRedisKey(this.region, key)));
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        finally {
            RedisCacheProvider.returnResource(jedis);
        }
    }

    @Override
    public void evict(List keys) throws CacheException {
        if (keys == null || keys.size() == 0) {
            return;
        }
        Jedis jedis = RedisCacheProvider.getResource();
        String[] _keys = new String[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            _keys[i] = CacheCodeUtils.createRedisKey(this.region, keys.get(i));
        }
        try {
            jedis.del(_keys);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        finally {
            RedisCacheProvider.returnResource(jedis);
        }
    }

    @Override
    public List keys() throws CacheException {
        Jedis jedis = RedisCacheProvider.getResource();
        ArrayList<String> listKey = new ArrayList<String>();
        try {
            listKey.addAll(jedis.keys(this.region + ":*"));
            int nKeyPreLen = this.region.length() + 3;
            for (int i = 0; i < listKey.size(); ++i) {
                listKey.set(i, ((String)listKey.get(i)).substring(nKeyPreLen));
            }
            ArrayList<String> arrayList = listKey;
            return arrayList;
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        finally {
            RedisCacheProvider.returnResource(jedis);
        }
    }

    @Override
    public void clear() throws CacheException {
        Jedis jedis = RedisCacheProvider.getResource();
        try {
            jedis.del(this.region + ":*");
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        finally {
            RedisCacheProvider.returnResource(jedis);
        }
    }

    @Override
    public void destroy() throws CacheException {
        this.clear();
    }
}

