/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.store.redis;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.store.redis.RedisCache;
import net.oschina.j2cache.utils.PropertiesLoader;
import net.oschina.j2cache.utils.StrExtUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisCacheProvider
implements CacheProvider {
    private final ConcurrentHashMap<String, RedisCache> cacheInstances = new ConcurrentHashMap();
    private static JedisPool pool;

    @Override
    public String name() {
        return "redis";
    }

    @Override
    public void start(Properties props) throws CacheException {
    }

    public static Jedis getResource() {
        return pool.getResource();
    }

    public static void returnResource(Jedis jedis) {
        if (null == jedis) {
            return;
        }
        pool.returnResourceObject((Object)jedis);
    }

    @Override
    public Cache buildCache(String regionName, boolean autoCreate, CacheExpiredListener listener) throws CacheException {
        if (this.cacheInstances.get(regionName) == null) {
            this.cacheInstances.put(regionName, new RedisCache(regionName));
        }
        return this.cacheInstances.get(regionName);
    }

    @Override
    public void start(String confFilePath) throws CacheException {
        if (pool != null) {
            return;
        }
        if (confFilePath == null || "".equals(confFilePath)) {
            throw new CacheException(String.format("\u7f13\u5b58\u7684Redis\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u9519\u8bef : %s", confFilePath));
        }
        Properties props = new PropertiesLoader(confFilePath).getProperties();
        try {
            if (props.isEmpty()) {
                throw new Exception(String.format("\u8bfb\u53d6\u7f13\u5b58Redis\u914d\u7f6e\u6587\u4ef6\u9519\u8bef : %s", confFilePath));
            }
            JedisPoolConfig config = new JedisPoolConfig();
            String host = RedisCacheProvider.getProperty(props, "cache.redis.hostname", "127.0.0.1");
            String password = props.getProperty("cache.redis.password", null);
            if (StrExtUtils.isNullOrEmpty(password)) {
                password = null;
            }
            int port = RedisCacheProvider.getProperty(props, "cache.redis.port", 6379);
            int timeout = RedisCacheProvider.getProperty(props, "cache.redis.timeout", 2000);
            int database = RedisCacheProvider.getProperty(props, "cache.redis.database", 0);
            pool = new JedisPool((GenericObjectPoolConfig)config, host, port, timeout, password, database);
        }
        catch (Exception e) {
            throw new CacheException("\u521b\u5efaCacheProvider\u5b9e\u4f8b\u5931\u8d25.", e);
        }
    }

    @Override
    public void stop() {
        pool.destroy();
    }

    private static String getProperty(Properties props, String key, String defaultValue) {
        return props.getProperty(key, defaultValue).trim();
    }

    private static int getProperty(Properties props, String key, int defaultValue) {
        try {
            return Integer.parseInt(props.getProperty(key, String.valueOf(defaultValue)).trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static boolean getProperty(Properties props, String key, boolean defaultValue) {
        return "true".equalsIgnoreCase(props.getProperty(key, String.valueOf(defaultValue)).trim());
    }
}

