/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesLoader.class);
    private final Properties properties;

    public PropertiesLoader(String ... resourcesPaths) {
        this.properties = this.loadProperties(resourcesPaths);
    }

    public Properties getProperties() {
        return this.properties;
    }

    private String getValue(String key) {
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        return this.properties.getProperty(key);
    }

    public String getProperty(String key) {
        String value = this.getValue(key);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getValue(key);
        return value != null ? value : defaultValue;
    }

    public Integer getInteger(String key) {
        String value = this.getValue(key);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return Integer.valueOf(value);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        String value = this.getValue(key);
        return value != null ? Integer.valueOf(value) : defaultValue;
    }

    public Double getDouble(String key) {
        String value = this.getValue(key);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return Double.valueOf(value);
    }

    public Double getDouble(String key, Integer defaultValue) {
        String value = this.getValue(key);
        return value != null ? Double.valueOf(value) : (double)defaultValue.intValue();
    }

    public Boolean getBoolean(String key) {
        String value = this.getValue(key);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return Boolean.valueOf(value);
    }

    public Boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getValue(key);
        return value != null ? Boolean.valueOf(value) : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String ... resourcesPaths) {
        Properties props = new Properties();
        for (String location : resourcesPaths) {
            logger.debug("Loading properties file from path:{}", (Object)location);
            InputStream is = null;
            try {
                is = this.getResourceAsInputStream(location);
                props.load(is);
            }
            catch (IOException ex) {
                logger.warn("Could not load properties from path:{}, {} ", (Object)location, (Object)ex.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return props;
    }

    public InputStream getResourceAsInputStream(String filePath) {
        assert (filePath != null) : "filePath must not be null!";
        if (filePath.startsWith("/")) {
            return PropertiesLoader.getDefaultClassLoader().getResourceAsStream(filePath.substring(1));
        }
        if (filePath.startsWith("classpath:")) {
            return this.getResourceAsInputStream(filePath.substring("classpath:".length()));
        }
        if (filePath.startsWith("classpath*:")) {
            return this.getResourceAsInputStream(filePath.substring("classpath*:".length()));
        }
        return PropertiesLoader.getDefaultClassLoader().getResourceAsStream(filePath);
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (cl == null && (cl = PropertiesLoader.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cl;
    }
}

