/*
 * Decompiled with CFR 0.152.
 */
package com.didalgo.gpt3;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public interface ByteSequence {
    public static final ByteSequence EMPTY = ByteSequence.of(new byte[0]);

    public byte byteAt(int var1);

    public int length();

    public ByteSequence subSequence(int var1, int var2) throws IndexOutOfBoundsException;

    public int hashCode();

    public boolean equals(Object var1);

    public byte[] toByteArray();

    public String toString(Charset var1);

    public static ByteSequence of(byte[] bytes) {
        return new Of(Arrays.copyOf(bytes, bytes.length));
    }

    public static ByteSequence copyOf(ByteSequence sequence) {
        if (sequence instanceof Of) {
            return sequence;
        }
        return ByteSequence.of(sequence.toByteArray());
    }

    public static ByteSequence from(String text) {
        return ByteSequence.from(text, StandardCharsets.UTF_8);
    }

    public static ByteSequence from(String text, Charset charset) {
        return new Of(text.getBytes(charset));
    }

    public static final class Of
    implements ByteSequence,
    Comparable<Of> {
        private final byte[] bytes;

        private Of(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public byte byteAt(int index) {
            if (index < 0 || index >= this.length()) {
                throw new IndexOutOfBoundsException("Index " + index + " is out of range (0 <= index < " + this.length() + ")");
            }
            return this.bytes[index];
        }

        @Override
        public int length() {
            return this.bytes.length;
        }

        @Override
        public Of subSequence(int start, int end) {
            return new Of(Arrays.copyOfRange(this.bytes, start, end));
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Of) {
                Of other = (Of)obj;
                return Arrays.equals(this.bytes, other.bytes);
            }
            return false;
        }

        @Override
        public byte[] toByteArray() {
            return Arrays.copyOf(this.bytes, this.bytes.length);
        }

        @Override
        public String toString(Charset charset) {
            return new String(this.bytes, charset);
        }

        public String toString() {
            return this.toString(StandardCharsets.UTF_8);
        }

        @Override
        public int compareTo(Of other) {
            return Arrays.compare(this.bytes, other.bytes);
        }
    }
}

