/*
 * Decompiled with CFR 0.152.
 */
package com.didalgo.gpt3;

import com.didalgo.gpt3.ByteSequence;
import java.util.Arrays;

public class ByteSequenceIntMap {
    private final RadixTreeNode rootNode = new RadixTreeNode();

    public void put(ByteSequence key, int value) {
        this.rootNode.put(key, value);
    }

    public int get(ByteSequence key) {
        return this.rootNode.get(key);
    }

    private static class RadixTreeNode
    implements Comparable<RadixTreeNode> {
        private static final RadixTreeNode[] ZERO_CHILDREN = new RadixTreeNode[0];
        private int value = -1;
        private byte label;
        private RadixTreeNode[] children;

        public RadixTreeNode() {
            this.children = ZERO_CHILDREN;
        }

        public RadixTreeNode(byte label) {
            this.label = label;
            this.children = ZERO_CHILDREN;
        }

        public void put(ByteSequence key, int value) {
            if (key.length() == 0) {
                this.value = value;
            } else {
                int index = this.indexOf(key.byteAt(0));
                if (index < 0) {
                    index = this.addNode(key.byteAt(0));
                }
                this.children[index].put(key.subSequence(1, key.length()), value);
            }
        }

        public int get(ByteSequence key) {
            return this.get(key, 0, key.length());
        }

        public int get(ByteSequence key, int from, int to) {
            if (from == to) {
                return this.value;
            }
            int index = this.indexOf(key.byteAt(from));
            if (index < 0) {
                return -1;
            }
            return this.children[index].get(key, from + 1, to);
        }

        private int indexOf(byte label) {
            if (this.children.length == 256) {
                return label + 128;
            }
            return Arrays.binarySearch(this.children, new RadixTreeNode(label));
        }

        private int addNode(byte label) {
            RadixTreeNode newNode = new RadixTreeNode(label);
            int newIndex = Arrays.binarySearch(this.children, newNode);
            if (newIndex < 0) {
                newIndex = -(newIndex + 1);
            }
            this.children = Arrays.copyOf(this.children, this.children.length + 1);
            System.arraycopy(this.children, newIndex, this.children, newIndex + 1, this.children.length - newIndex - 1);
            this.children[newIndex] = newNode;
            return newIndex;
        }

        @Override
        public int compareTo(RadixTreeNode that) {
            return Byte.compare(this.label, that.label);
        }
    }
}

