/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.ssl;

import com.dtflys.forest.Forest;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.ssl.SSLKeyStore;
import com.dtflys.forest.ssl.SSLSocketFactoryBuilder;
import com.dtflys.forest.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.TrustManager;
import org.springframework.core.io.ClassPathResource;

public class SpringSSLKeyStore
extends SSLKeyStore {
    private static SSLSocketFactoryBuilder getSSLSocketFactoryBuilder(String sslSocketFactoryBuilderClass) {
        if (StringUtils.isBlank((String)sslSocketFactoryBuilderClass)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(sslSocketFactoryBuilderClass);
            if (!SSLSocketFactoryBuilder.class.isAssignableFrom(clazz)) {
                throw new ForestRuntimeException("[Forest] The value of property 'sslSocketFactoryBuilder' must be a class inherited from com.dtflys.forest.ssl.SSLSocketFactoryBuilder");
            }
            return (SSLSocketFactoryBuilder)Forest.config().getForestObjectFactory().getObject(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new ForestRuntimeException((Throwable)e);
        }
    }

    private static TrustManager getTrustManager(String trustManagerClass) {
        if (StringUtils.isBlank((String)trustManagerClass)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(trustManagerClass);
            if (!TrustManager.class.isAssignableFrom(clazz)) {
                throw new ForestRuntimeException("[Forest] The value of property 'trustManager' must be a class inherited from javax.net.ssl.TrustManager");
            }
            return (TrustManager)Forest.config().getForestObjectFactory().getObject(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new ForestRuntimeException((Throwable)e);
        }
    }

    private static HostnameVerifier getHostnameVerifier(String hostnameVerifierClass) {
        if (StringUtils.isBlank((String)hostnameVerifierClass)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(hostnameVerifierClass);
            if (!HostnameVerifier.class.isAssignableFrom(clazz)) {
                throw new ForestRuntimeException("[Forest] The value of property 'hostnameVerifier' must be a class inherited from javax.net.ssl.HostnameVerifier");
            }
            return (HostnameVerifier)Forest.config().getForestObjectFactory().getObject(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new ForestRuntimeException((Throwable)e);
        }
    }

    public SpringSSLKeyStore(String id, String keystoreType, String filePath, String keystorePass, String certPass, String trustManagerClass, String hostnameVerifierClass, String sslSocketFactoryBuilderClass) {
        super(id, keystoreType, filePath, keystorePass, certPass, SpringSSLKeyStore.getTrustManager(trustManagerClass), SpringSSLKeyStore.getHostnameVerifier(hostnameVerifierClass), SpringSSLKeyStore.getSSLSocketFactoryBuilder(sslSocketFactoryBuilderClass));
    }

    public void init() {
        if (StringUtils.isBlank((String)this.filePath)) {
            return;
        }
        if (this.filePath.indexOf(":/") == 1 || this.filePath.indexOf(":\\") == 1 || this.filePath.startsWith("/")) {
            File file = new File(this.filePath);
            if (!file.exists()) {
                throw new ForestRuntimeException("The file of SSL KeyStore \"" + this.id + "\" " + this.filePath + " cannot be found!");
            }
            try {
                this.inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new ForestRuntimeException("An error occurred while reading he file of SSL KeyStore \"\" + id + \"\"", (Throwable)e);
            }
        }
        ClassPathResource resource = new ClassPathResource(this.filePath);
        if (!resource.exists()) {
            throw new ForestRuntimeException("The file of SSL KeyStore \"" + this.id + "\" " + this.filePath + " cannot be found!");
        }
        try {
            this.inputStream = resource.getInputStream();
        }
        catch (IOException e) {
            throw new ForestRuntimeException("An error occurred while reading he file of SSL KeyStore \"\" + id + \"\"", (Throwable)e);
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

