/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1.agent;

import com.ecwid.consul.SingleUrlParameters;
import com.ecwid.consul.UrlParameters;
import com.ecwid.consul.json.GsonFactory;
import com.ecwid.consul.transport.RawResponse;
import com.ecwid.consul.v1.ConsulRawClient;
import com.ecwid.consul.v1.OperationException;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.AgentClient;
import com.ecwid.consul.v1.agent.model.Check;
import com.ecwid.consul.v1.agent.model.Member;
import com.ecwid.consul.v1.agent.model.NewCheck;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.agent.model.Self;
import com.ecwid.consul.v1.agent.model.Service;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public final class AgentConsulClient
implements AgentClient {
    private final ConsulRawClient rawClient;

    public AgentConsulClient(ConsulRawClient rawClient) {
        this.rawClient = rawClient;
    }

    public AgentConsulClient() {
        this(new ConsulRawClient());
    }

    public AgentConsulClient(String agentHost) {
        this(new ConsulRawClient(agentHost));
    }

    public AgentConsulClient(String agentHost, int agentPort) {
        this(new ConsulRawClient(agentHost, agentPort));
    }

    @Override
    public Response<Map<String, Check>> getAgentChecks() {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/agent/checks", new UrlParameters[0]);
        if (rawResponse.getStatusCode() == 200) {
            Map value = (Map)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<Map<String, Check>>(){}.getType());
            return new Response<Map<String, Check>>(value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Map<String, Service>> getAgentServices() {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/agent/services", new UrlParameters[0]);
        if (rawResponse.getStatusCode() == 200) {
            Map agentServices = (Map)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<Map<String, Service>>(){}.getType());
            return new Response<Map<String, Service>>(agentServices, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<Member>> getAgentMembers() {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/agent/members", new UrlParameters[0]);
        if (rawResponse.getStatusCode() == 200) {
            List members = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<Member>>(){}.getType());
            return new Response<List<Member>>(members, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Self> getAgentSelf() {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/agent/self", new UrlParameters[0]);
        if (rawResponse.getStatusCode() == 200) {
            Self self = (Self)GsonFactory.getGson().fromJson(rawResponse.getContent(), Self.class);
            return new Response<Self>(self, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Void> agentJoin(String address, boolean wan) {
        SingleUrlParameters wanParams = wan ? new SingleUrlParameters("wan", "1") : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/agent/join/" + address, wanParams);
        if (rawResponse.getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Void> agentForceLeave(String node) {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/agent/force-leave/" + node, new UrlParameters[0]);
        if (rawResponse.getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Void> agentCheckRegister(NewCheck newCheck) {
        String json = GsonFactory.getGson().toJson((Object)newCheck);
        RawResponse rawResponse = this.rawClient.makePutRequest("/v1/agent/check/register", json, new UrlParameters[0]);
        if (rawResponse.getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Void> agentCheckDeregister(String checkId) {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/agent/check/deregister/" + checkId, new UrlParameters[0]);
        if (rawResponse.getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Void> agentCheckPass(String checkId) {
        return this.agentCheckPass(checkId, null);
    }

    @Override
    public Response<Void> agentCheckPass(String checkId, String note) {
        SingleUrlParameters noteParams = note != null ? new SingleUrlParameters("note", note) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/agent/check/pass/" + checkId, noteParams);
        if (rawResponse.getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Void> agentCheckWarn(String checkId) {
        return this.agentCheckWarn(checkId, null);
    }

    @Override
    public Response<Void> agentCheckWarn(String checkId, String note) {
        SingleUrlParameters noteParams = note != null ? new SingleUrlParameters("note", note) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/agent/check/warn/" + checkId, noteParams);
        if (rawResponse.getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Void> agentCheckFail(String checkId) {
        return this.agentCheckFail(checkId, null);
    }

    @Override
    public Response<Void> agentCheckFail(String checkId, String note) {
        SingleUrlParameters noteParams = note != null ? new SingleUrlParameters("note", note) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/agent/check/fail/" + checkId, noteParams);
        if (rawResponse.getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Void> agentServiceRegister(NewService newService) {
        String json = GsonFactory.getGson().toJson((Object)newService);
        RawResponse rawResponse = this.rawClient.makePutRequest("/v1/agent/service/register", json, new UrlParameters[0]);
        if (rawResponse.getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Void> agentServiceDeregister(String serviceId) {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/agent/service/deregister/" + serviceId, new UrlParameters[0]);
        if (rawResponse.getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }
}

