/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.boot;

import com.ejlchina.searcher.BeanReflector;
import com.ejlchina.searcher.BeanSearcher;
import com.ejlchina.searcher.DbMapping;
import com.ejlchina.searcher.FieldConvertor;
import com.ejlchina.searcher.FieldOp;
import com.ejlchina.searcher.FieldOpPool;
import com.ejlchina.searcher.MapSearcher;
import com.ejlchina.searcher.MetaResolver;
import com.ejlchina.searcher.PageExtractor;
import com.ejlchina.searcher.ParamFilter;
import com.ejlchina.searcher.ParamResolver;
import com.ejlchina.searcher.ResultFilter;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SnippetResolver;
import com.ejlchina.searcher.SqlExecutor;
import com.ejlchina.searcher.SqlInterceptor;
import com.ejlchina.searcher.SqlResolver;
import com.ejlchina.searcher.boot.BeanSearcherProperties;
import com.ejlchina.searcher.boot.NamedDataSource;
import com.ejlchina.searcher.dialect.Dialect;
import com.ejlchina.searcher.dialect.MySqlDialect;
import com.ejlchina.searcher.dialect.OracleDialect;
import com.ejlchina.searcher.dialect.PostgreSqlDialect;
import com.ejlchina.searcher.group.DefaultGroupResolver;
import com.ejlchina.searcher.group.DefaultParserFactory;
import com.ejlchina.searcher.group.ExprParser;
import com.ejlchina.searcher.group.GroupResolver;
import com.ejlchina.searcher.implement.B2MFieldConvertor;
import com.ejlchina.searcher.implement.BoolFieldConvertor;
import com.ejlchina.searcher.implement.DateFieldConvertor;
import com.ejlchina.searcher.implement.DateFormatFieldConvertor;
import com.ejlchina.searcher.implement.DateValueCorrector;
import com.ejlchina.searcher.implement.DefaultBeanReflector;
import com.ejlchina.searcher.implement.DefaultBeanSearcher;
import com.ejlchina.searcher.implement.DefaultDbMapping;
import com.ejlchina.searcher.implement.DefaultMapSearcher;
import com.ejlchina.searcher.implement.DefaultMetaResolver;
import com.ejlchina.searcher.implement.DefaultParamResolver;
import com.ejlchina.searcher.implement.DefaultSqlExecutor;
import com.ejlchina.searcher.implement.DefaultSqlResolver;
import com.ejlchina.searcher.implement.EnumFieldConvertor;
import com.ejlchina.searcher.implement.NumberFieldConvertor;
import com.ejlchina.searcher.implement.PageOffsetExtractor;
import com.ejlchina.searcher.implement.PageSizeExtractor;
import com.ejlchina.searcher.implement.StrNumFieldConvertor;
import com.ejlchina.searcher.implement.TimeFieldConvertor;
import com.ejlchina.searcher.util.LRUCache;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={BeanSearcherProperties.class})
public class BeanSearcherAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={PageExtractor.class})
    public PageExtractor pageExtractor(BeanSearcherProperties config) {
        PageSizeExtractor extractor;
        BeanSearcherProperties.Params.PaginationProps conf = config.getParams().getPagination();
        String type = conf.getType();
        if ("page".equals(type)) {
            PageSizeExtractor p = new PageSizeExtractor();
            p.setPageName(conf.getPage());
            extractor = p;
        } else if ("offset".equals(type)) {
            PageOffsetExtractor p = new PageOffsetExtractor();
            p.setOffsetName(conf.getOffset());
            extractor = p;
        } else {
            throw new SearchException("\u914d\u7f6e\u9879 [bean-searcher.params.pagination.type] \u53ea\u80fd\u4e3a page \u6216 offset\uff01");
        }
        extractor.setMaxAllowedSize(conf.getMaxAllowedSize());
        extractor.setSizeName(conf.getSize());
        extractor.setStart(conf.getStart());
        extractor.setDefaultSize(conf.getDefaultSize());
        return extractor;
    }

    @Bean
    @ConditionalOnMissingBean(value={Dialect.class})
    public Dialect dialect(BeanSearcherProperties config) {
        String dialect = config.getSql().getDialect();
        if (dialect == null) {
            throw new SearchException("\u914d\u7f6e\u9879\u3010bean-searcher.sql.dialect\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (dialect.toUpperCase()) {
            case "MYSQL": {
                return new MySqlDialect();
            }
            case "ORACLE": {
                return new OracleDialect();
            }
            case "POSTGRESQL": 
            case "PGSQL": {
                return new PostgreSqlDialect();
            }
        }
        throw new SearchException("\u914d\u7f6e\u9879\u3010bean-searcher.sql.dialect\u3011\u53ea\u80fd\u4e3a  MySql | Oracle \u4e2d\u7684\u4e00\u4e2a\uff0c\u82e5\u9700\u652f\u6301\u5176\u5b83\u65b9\u8a00\uff0c\u53ef\u81ea\u5df1\u6ce8\u5165\u4e00\u4e2a com.ejlchina.searcher.dialect.Dialect \u7c7b\u578b\u7684 Bean\uff01");
    }

    @Bean
    @ConditionalOnMissingBean(value={FieldOpPool.class})
    public FieldOpPool fieldOpPool(Dialect dialect, ObjectProvider<List<FieldOp>> fieldOps) {
        FieldOpPool pool = new FieldOpPool();
        this.ifAvailable(fieldOps, ops -> ops.forEach(arg_0 -> ((FieldOpPool)pool).addFieldOp(arg_0)));
        pool.setDialect(dialect);
        return pool;
    }

    @Bean
    @ConditionalOnMissingBean(value={ExprParser.Factory.class})
    public ExprParser.Factory parserFactory() {
        return new DefaultParserFactory();
    }

    @Bean
    @ConditionalOnMissingBean(value={GroupResolver.class})
    public GroupResolver groupResolver(BeanSearcherProperties config, ExprParser.Factory parserFactory) {
        DefaultGroupResolver groupResolver = new DefaultGroupResolver();
        BeanSearcherProperties.Params.Group conf = config.getParams().getGroup();
        groupResolver.setEnabled(conf.isEnable());
        groupResolver.setCache(new LRUCache(conf.getCacheSize()));
        groupResolver.setParserFactory(parserFactory);
        return groupResolver;
    }

    @Bean
    @ConditionalOnMissingBean(value={ParamResolver.class})
    public ParamResolver paramResolver(PageExtractor pageExtractor, FieldOpPool fieldOpPool, ObjectProvider<ParamFilter[]> paramFilters, GroupResolver groupResolver, BeanSearcherProperties config) {
        DefaultParamResolver paramResolver = new DefaultParamResolver();
        paramResolver.setPageExtractor(pageExtractor);
        paramResolver.setFieldOpPool(fieldOpPool);
        this.ifAvailable(paramFilters, arg_0 -> ((DefaultParamResolver)paramResolver).setParamFilters(arg_0));
        BeanSearcherProperties.Params conf = config.getParams();
        paramResolver.setOperatorSuffix(conf.getOperatorKey());
        paramResolver.setIgnoreCaseSuffix(conf.getIgnoreCaseKey());
        paramResolver.setOrderName(conf.getOrder());
        paramResolver.setSortName(conf.getSort());
        paramResolver.setOrderByName(conf.getOrderBy());
        paramResolver.setSeparator(conf.getSeparator());
        paramResolver.setOnlySelectName(conf.getOnlySelect());
        paramResolver.setSelectExcludeName(conf.getSelectExclude());
        BeanSearcherProperties.Params.Group group = conf.getGroup();
        paramResolver.setGexprName(group.getExprName());
        paramResolver.setGroupSeparator(group.getSeparator());
        paramResolver.setGroupResolver(groupResolver);
        return paramResolver;
    }

    @Bean
    @ConditionalOnMissingBean(value={DateValueCorrector.class})
    @ConditionalOnProperty(name={"bean-searcher.sql.use-date-value-corrector"}, havingValue="true", matchIfMissing=true)
    public DateValueCorrector dateValueCorrector() {
        return new DateValueCorrector();
    }

    @Bean
    @ConditionalOnMissingBean(value={SqlResolver.class})
    public SqlResolver sqlResolver(Dialect dialect, ObjectProvider<DateValueCorrector> dateValueCorrector) {
        return new DefaultSqlResolver(dialect, (DateValueCorrector)dateValueCorrector.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean(value={SqlExecutor.class})
    public SqlExecutor sqlExecutor(ObjectProvider<DataSource> dataSource, ObjectProvider<List<NamedDataSource>> namedDataSources) {
        DefaultSqlExecutor executor = new DefaultSqlExecutor((DataSource)dataSource.getIfAvailable());
        this.ifAvailable(namedDataSources, ndsList -> {
            for (NamedDataSource nds : ndsList) {
                executor.setDataSource(nds.getName(), nds.getDataSource());
            }
        });
        return executor;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-number"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={NumberFieldConvertor.class})
    public NumberFieldConvertor numberFieldConvertor() {
        return new NumberFieldConvertor();
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-str-num"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={StrNumFieldConvertor.class})
    public StrNumFieldConvertor strNumFieldConvertor() {
        return new StrNumFieldConvertor();
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-bool"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={BoolFieldConvertor.class})
    public BoolFieldConvertor boolFieldConvertor(BeanSearcherProperties config) {
        String[] falseValues = config.getFieldConvertor().getBoolFalseValues();
        BoolFieldConvertor convertor = new BoolFieldConvertor();
        if (falseValues != null) {
            convertor.addFalseValues(falseValues);
        }
        return convertor;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-date"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={DateFieldConvertor.class})
    public DateFieldConvertor dateFieldConvertor(BeanSearcherProperties config) {
        DateFieldConvertor convertor = new DateFieldConvertor();
        ZoneId zoneId = config.getFieldConvertor().getZoneId();
        if (zoneId != null) {
            convertor.setZoneId(zoneId);
        }
        return convertor;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-time"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={TimeFieldConvertor.class})
    public TimeFieldConvertor timeFieldConvertor() {
        return new TimeFieldConvertor();
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-enum"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={EnumFieldConvertor.class})
    public EnumFieldConvertor enumFieldConvertor() {
        return new EnumFieldConvertor();
    }

    @Bean
    @ConditionalOnMissingBean(value={BeanReflector.class})
    public BeanReflector beanReflector(ObjectProvider<List<FieldConvertor.BFieldConvertor>> convertorsProvider) {
        List convertors = (List)convertorsProvider.getIfAvailable();
        if (convertors != null) {
            return new DefaultBeanReflector(convertors);
        }
        return new DefaultBeanReflector();
    }

    @Bean
    @ConditionalOnMissingBean(value={DbMapping.class})
    public DbMapping dbMapping(BeanSearcherProperties config) {
        DefaultDbMapping mapping = new DefaultDbMapping();
        BeanSearcherProperties.Sql.DefaultMapping conf = config.getSql().getDefaultMapping();
        mapping.setTablePrefix(conf.getTablePrefix());
        mapping.setUpperCase(conf.isUpperCase());
        mapping.setRedundantSuffixes(conf.getRedundantSuffixes());
        mapping.setIgnoreFields(conf.getIgnoreFields());
        mapping.setDefaultInheritType(conf.getInheritType());
        mapping.setDefaultSortType(conf.getSortType());
        return mapping;
    }

    @Bean
    @ConditionalOnMissingBean(value={MetaResolver.class})
    public MetaResolver metaResolver(DbMapping dbMapping, ObjectProvider<SnippetResolver> snippetResolver) {
        DefaultMetaResolver metaResolver = new DefaultMetaResolver(dbMapping);
        this.ifAvailable(snippetResolver, arg_0 -> ((DefaultMetaResolver)metaResolver).setSnippetResolver(arg_0));
        return metaResolver;
    }

    @Bean
    @ConditionalOnMissingBean(value={BeanSearcher.class})
    @ConditionalOnProperty(name={"bean-searcher.use-bean-searcher"}, havingValue="true", matchIfMissing=true)
    public BeanSearcher beanSearcher(MetaResolver metaResolver, ParamResolver paramResolver, SqlResolver sqlResolver, SqlExecutor sqlExecutor, BeanReflector beanReflector, ObjectProvider<List<SqlInterceptor>> interceptors, ObjectProvider<List<ResultFilter>> processors) {
        DefaultBeanSearcher searcher = new DefaultBeanSearcher();
        searcher.setMetaResolver(metaResolver);
        searcher.setParamResolver(paramResolver);
        searcher.setSqlResolver(sqlResolver);
        searcher.setSqlExecutor(sqlExecutor);
        searcher.setBeanReflector(beanReflector);
        this.ifAvailable(interceptors, arg_0 -> ((DefaultBeanSearcher)searcher).setInterceptors(arg_0));
        this.ifAvailable(processors, arg_0 -> ((DefaultBeanSearcher)searcher).setResultFilters(arg_0));
        return searcher;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-date-format"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={DateFormatFieldConvertor.class})
    public DateFormatFieldConvertor dateFormatFieldConvertor(BeanSearcherProperties config) {
        BeanSearcherProperties.FieldConvertor conf = config.getFieldConvertor();
        Map<String, String> dateFormats = conf.getDateFormats();
        ZoneId zoneId = conf.getZoneId();
        DateFormatFieldConvertor convertor = new DateFormatFieldConvertor();
        if (dateFormats != null) {
            dateFormats.forEach((arg_0, arg_1) -> ((DateFormatFieldConvertor)convertor).setFormat(arg_0, arg_1));
        }
        if (zoneId != null) {
            convertor.setZoneId(zoneId);
        }
        return convertor;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-b2-m"}, havingValue="true")
    @ConditionalOnMissingBean(value={B2MFieldConvertor.class})
    public B2MFieldConvertor b2mFieldConvertor(ObjectProvider<List<FieldConvertor.BFieldConvertor>> convertors) {
        List list = (List)convertors.getIfAvailable();
        if (list != null) {
            return new B2MFieldConvertor(list);
        }
        return new B2MFieldConvertor(Collections.emptyList());
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={MapSearcher.class})
    @ConditionalOnProperty(name={"bean-searcher.use-map-searcher"}, havingValue="true", matchIfMissing=true)
    public MapSearcher mapSearcher(MetaResolver metaResolver, ParamResolver paramResolver, SqlResolver sqlResolver, SqlExecutor sqlExecutor, ObjectProvider<List<FieldConvertor.MFieldConvertor>> convertors, ObjectProvider<List<SqlInterceptor>> interceptors, ObjectProvider<List<ResultFilter>> resultFilters) {
        DefaultMapSearcher searcher = new DefaultMapSearcher();
        searcher.setMetaResolver(metaResolver);
        searcher.setParamResolver(paramResolver);
        searcher.setSqlResolver(sqlResolver);
        searcher.setSqlExecutor(sqlExecutor);
        List list = (List)convertors.getIfAvailable();
        if (list != null) {
            ArrayList newList = new ArrayList(list);
            newList.sort((o1, o2) -> {
                if (o1 instanceof DateFormatFieldConvertor) {
                    return -1;
                }
                if (o2 instanceof DateFormatFieldConvertor) {
                    return 1;
                }
                return 0;
            });
            searcher.setConvertors(newList);
        }
        this.ifAvailable(interceptors, arg_0 -> ((DefaultMapSearcher)searcher).setInterceptors(arg_0));
        this.ifAvailable(resultFilters, arg_0 -> ((DefaultMapSearcher)searcher).setResultFilters(arg_0));
        return searcher;
    }

    private <T> void ifAvailable(ObjectProvider<T> provider, Consumer<T> consumer) {
        Object dependency = provider.getIfAvailable();
        if (dependency != null) {
            consumer.accept(dependency);
        }
    }
}

