/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.boot;

import com.ejlchina.searcher.bean.InheritType;
import com.ejlchina.searcher.bean.SortType;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="bean-searcher")
public class BeanSearcherProperties {
    private final Params params = new Params();
    private final Sql sql = new Sql();
    private final FieldConvertor fieldConvertor = new FieldConvertor();
    private boolean useMapSearcher = true;
    private boolean useBeanSearcher = true;

    public Params getParams() {
        return this.params;
    }

    public Sql getSql() {
        return this.sql;
    }

    public FieldConvertor getFieldConvertor() {
        return this.fieldConvertor;
    }

    public boolean isUseMapSearcher() {
        return this.useMapSearcher;
    }

    public void setUseMapSearcher(boolean useMapSearcher) {
        this.useMapSearcher = useMapSearcher;
    }

    public boolean isUseBeanSearcher() {
        return this.useBeanSearcher;
    }

    public void setUseBeanSearcher(boolean useBeanSearcher) {
        this.useBeanSearcher = useBeanSearcher;
    }

    public static class FieldConvertor {
        private boolean useNumber = true;
        private boolean useStrNum = true;
        private boolean useBoolNum = true;
        private boolean useBool = true;
        private String[] boolFalseValues;
        private boolean useDate = true;
        private boolean useDateFormat = true;
        private boolean useTime = true;
        private ZoneId zoneId = null;
        private Map<String, String> dateFormats = new HashMap<String, String>();
        private boolean useEnum = true;
        private boolean enumFailOnError = true;
        private boolean enumIgnoreCase = false;
        private boolean useB2M = false;

        public boolean isUseNumber() {
            return this.useNumber;
        }

        public void setUseNumber(boolean useNumber) {
            this.useNumber = useNumber;
        }

        public boolean isUseStrNum() {
            return this.useStrNum;
        }

        public void setUseStrNum(boolean useStrNum) {
            this.useStrNum = useStrNum;
        }

        public boolean isUseBoolNum() {
            return this.useBoolNum;
        }

        public void setUseBoolNum(boolean useBoolNum) {
            this.useBoolNum = useBoolNum;
        }

        public boolean isUseBool() {
            return this.useBool;
        }

        public void setUseBool(boolean useBool) {
            this.useBool = useBool;
        }

        public String[] getBoolFalseValues() {
            return this.boolFalseValues;
        }

        public void setBoolFalseValues(String[] boolFalseValues) {
            this.boolFalseValues = boolFalseValues;
        }

        public boolean isUseDate() {
            return this.useDate;
        }

        public void setUseDate(boolean useDate) {
            this.useDate = useDate;
        }

        public boolean isUseDateFormat() {
            return this.useDateFormat;
        }

        public void setUseDateFormat(boolean useDateFormat) {
            this.useDateFormat = useDateFormat;
        }

        public Map<String, String> getDateFormats() {
            return this.dateFormats;
        }

        public void setDateFormats(Map<String, String> dateFormats) {
            this.dateFormats = dateFormats;
        }

        public boolean isUseTime() {
            return this.useTime;
        }

        public void setUseTime(boolean useTime) {
            this.useTime = useTime;
        }

        public ZoneId getZoneId() {
            return this.zoneId;
        }

        public void setZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        public boolean isUseEnum() {
            return this.useEnum;
        }

        public void setUseEnum(boolean useEnum) {
            this.useEnum = useEnum;
        }

        public boolean isEnumFailOnError() {
            return this.enumFailOnError;
        }

        public void setEnumFailOnError(boolean enumFailOnError) {
            this.enumFailOnError = enumFailOnError;
        }

        public boolean isEnumIgnoreCase() {
            return this.enumIgnoreCase;
        }

        public void setEnumIgnoreCase(boolean enumIgnoreCase) {
            this.enumIgnoreCase = enumIgnoreCase;
        }

        public boolean isUseB2M() {
            return this.useB2M;
        }

        public void setUseB2M(boolean useB2M) {
            this.useB2M = useB2M;
        }
    }

    public static class Sql {
        private Dialect dialect = Dialect.MySQL;
        private final DefaultMapping defaultMapping = new DefaultMapping();
        private long slowSqlThreshold = 500L;

        public Dialect getDialect() {
            return this.dialect;
        }

        public void setDialect(Dialect dialect) {
            this.dialect = dialect;
        }

        public DefaultMapping getDefaultMapping() {
            return this.defaultMapping;
        }

        public long getSlowSqlThreshold() {
            return this.slowSqlThreshold;
        }

        public void setSlowSqlThreshold(long slowSqlThreshold) {
            this.slowSqlThreshold = slowSqlThreshold;
        }

        public static class DefaultMapping {
            private boolean upperCase = false;
            private boolean underlineCase = true;
            private String tablePrefix = null;
            private String[] redundantSuffixes;
            private String[] ignoreFields;
            private InheritType inheritType = InheritType.ALL;
            private SortType sortType = SortType.ALLOW_PARAM;

            public boolean isUpperCase() {
                return this.upperCase;
            }

            public void setUpperCase(boolean upperCase) {
                this.upperCase = upperCase;
            }

            public boolean isUnderlineCase() {
                return this.underlineCase;
            }

            public void setUnderlineCase(boolean underlineCase) {
                this.underlineCase = underlineCase;
            }

            public String getTablePrefix() {
                return this.tablePrefix;
            }

            public void setTablePrefix(String tablePrefix) {
                this.tablePrefix = tablePrefix;
            }

            public String[] getRedundantSuffixes() {
                return this.redundantSuffixes;
            }

            public void setRedundantSuffixes(String[] redundantSuffixes) {
                this.redundantSuffixes = redundantSuffixes;
            }

            public String[] getIgnoreFields() {
                return this.ignoreFields;
            }

            public void setIgnoreFields(String[] ignoreFields) {
                this.ignoreFields = ignoreFields;
            }

            public InheritType getInheritType() {
                return this.inheritType;
            }

            public void setInheritType(InheritType inheritType) {
                this.inheritType = inheritType;
            }

            public SortType getSortType() {
                return this.sortType;
            }

            public void setSortType(SortType sortType) {
                this.sortType = sortType;
            }
        }

        static enum Dialect {
            MySQL,
            Oracle,
            PostgreSQL,
            PgSQL,
            SqlServer;

        }
    }

    public static class Params {
        private String sort = "sort";
        private String order = "order";
        private String orderBy = "orderBy";
        private String separator = "-";
        private String ignoreCaseKey = "ic";
        private String operatorKey = "op";
        private String onlySelect = "onlySelect";
        private String selectExclude = "selectExclude";
        private final Filter filter = new Filter();
        private final Group group = new Group();
        private final Pagination pagination = new Pagination();

        public String getSort() {
            return this.sort;
        }

        public void setSort(String sort) {
            this.sort = sort;
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.separator = separator;
        }

        public String getIgnoreCaseKey() {
            return this.ignoreCaseKey;
        }

        public void setIgnoreCaseKey(String ignoreCaseKey) {
            this.ignoreCaseKey = ignoreCaseKey;
        }

        public String getOperatorKey() {
            return this.operatorKey;
        }

        public void setOperatorKey(String operatorKey) {
            this.operatorKey = operatorKey;
        }

        public String getOnlySelect() {
            return this.onlySelect;
        }

        public void setOnlySelect(String onlySelect) {
            this.onlySelect = onlySelect;
        }

        public String getSelectExclude() {
            return this.selectExclude;
        }

        public void setSelectExclude(String selectExclude) {
            this.selectExclude = selectExclude;
        }

        public Group getGroup() {
            return this.group;
        }

        public Pagination getPagination() {
            return this.pagination;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public static class Pagination {
            public static final String TYPE_PAGE = "page";
            public static final String TYPE_OFFSET = "offset";
            private int defaultSize = 15;
            private String type = "page";
            private String size = "size";
            private String page = "page";
            private String offset = "offset";
            private int start = 0;
            private int maxAllowedSize = 100;
            private long maxAllowedOffset = 20000L;

            public int getDefaultSize() {
                return this.defaultSize;
            }

            public void setDefaultSize(int defaultSize) {
                this.defaultSize = defaultSize;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
                this.type = type;
            }

            public String getSize() {
                return this.size;
            }

            public void setSize(String size) {
                this.size = size;
            }

            public String getPage() {
                return this.page;
            }

            public void setPage(String page) {
                this.page = page;
            }

            public String getOffset() {
                return this.offset;
            }

            public void setOffset(String offset) {
                this.offset = offset;
            }

            public int getStart() {
                return this.start;
            }

            public void setStart(int start) {
                this.start = start;
            }

            public int getMaxAllowedSize() {
                return this.maxAllowedSize;
            }

            public void setMaxAllowedSize(int maxAllowedSize) {
                this.maxAllowedSize = maxAllowedSize;
            }

            public long getMaxAllowedOffset() {
                return this.maxAllowedOffset;
            }

            public void setMaxAllowedOffset(long maxAllowedOffset) {
                this.maxAllowedOffset = maxAllowedOffset;
            }
        }

        public static class Group {
            private boolean enable = true;
            private String exprName = "gexpr";
            private String separator = ".";
            private int cacheSize = 50;
            private int maxExprLength = 50;

            public boolean isEnable() {
                return this.enable;
            }

            public void setEnable(boolean enable) {
                this.enable = enable;
            }

            public String getExprName() {
                return this.exprName;
            }

            public void setExprName(String exprName) {
                this.exprName = exprName;
            }

            public String getSeparator() {
                return this.separator;
            }

            public void setSeparator(String separator) {
                this.separator = separator;
            }

            public int getCacheSize() {
                return this.cacheSize;
            }

            public void setCacheSize(int cacheSize) {
                this.cacheSize = cacheSize;
            }

            public int getMaxExprLength() {
                return this.maxExprLength;
            }

            public void setMaxExprLength(int maxExprLength) {
                this.maxExprLength = maxExprLength;
            }
        }

        public static class Filter {
            private int maxParaMapSize = 150;

            public int getMaxParaMapSize() {
                return this.maxParaMapSize;
            }

            public void setMaxParaMapSize(int maxParaMapSize) {
                this.maxParaMapSize = maxParaMapSize;
            }
        }
    }
}

