/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher;

import com.ejlchina.searcher.FieldOp;
import com.ejlchina.searcher.dialect.Dialect;
import com.ejlchina.searcher.dialect.DialectSensor;
import com.ejlchina.searcher.implement.DialectWrapper;
import com.ejlchina.searcher.operator.Between;
import com.ejlchina.searcher.operator.Contain;
import com.ejlchina.searcher.operator.Empty;
import com.ejlchina.searcher.operator.EndWith;
import com.ejlchina.searcher.operator.Equal;
import com.ejlchina.searcher.operator.GreaterEqual;
import com.ejlchina.searcher.operator.GreaterThan;
import com.ejlchina.searcher.operator.InList;
import com.ejlchina.searcher.operator.IsNull;
import com.ejlchina.searcher.operator.LessEqual;
import com.ejlchina.searcher.operator.LessThan;
import com.ejlchina.searcher.operator.NotBetween;
import com.ejlchina.searcher.operator.NotEmpty;
import com.ejlchina.searcher.operator.NotEqual;
import com.ejlchina.searcher.operator.NotIn;
import com.ejlchina.searcher.operator.NotNull;
import com.ejlchina.searcher.operator.StartWith;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class FieldOpPool
extends DialectWrapper {
    private List<FieldOp> fieldOps;
    private final Map<Object, FieldOp> cache = new ConcurrentHashMap<Object, FieldOp>();

    public FieldOpPool(List<FieldOp> fieldOps) {
        this.fieldOps = Objects.requireNonNull(fieldOps);
    }

    public FieldOpPool() {
        this.fieldOps = new ArrayList<FieldOp>();
        this.fieldOps.add(new Equal());
        this.fieldOps.add(new NotEqual());
        this.fieldOps.add(new GreaterThan());
        this.fieldOps.add(new GreaterEqual());
        this.fieldOps.add(new LessThan());
        this.fieldOps.add(new LessEqual());
        this.fieldOps.add(new Between());
        this.fieldOps.add(new NotBetween());
        this.fieldOps.add(new Contain());
        this.fieldOps.add(new StartWith());
        this.fieldOps.add(new EndWith());
        this.fieldOps.add(new InList());
        this.fieldOps.add(new NotIn());
        this.fieldOps.add(new IsNull());
        this.fieldOps.add(new NotNull());
        this.fieldOps.add(new Empty());
        this.fieldOps.add(new NotEmpty());
    }

    public FieldOp getFieldOp(Object key) {
        if (key == null) {
            return null;
        }
        FieldOp fOp = this.cache.get(key);
        if (fOp == null && key instanceof FieldOp) {
            fOp = this.cache.get(((FieldOp)key).name());
        }
        if (fOp != null) {
            return fOp;
        }
        for (FieldOp op : this.fieldOps) {
            if (!this.isMatch(op, key)) continue;
            if (key instanceof FieldOp) {
                this.cache.put(((FieldOp)key).name(), op);
            } else {
                this.cache.put(key, op);
            }
            return op;
        }
        return null;
    }

    private boolean isMatch(FieldOp op, Object key) {
        if (key instanceof FieldOp) {
            return op.sameTo((FieldOp)key);
        }
        if (key instanceof String) {
            return op.isNamed((String)key);
        }
        if (key instanceof Class) {
            return op.getClass() == key;
        }
        return false;
    }

    public List<FieldOp> getFieldOps() {
        return this.fieldOps;
    }

    public synchronized void setFieldOps(List<FieldOp> fieldOps) {
        this.fieldOps = Objects.requireNonNull(fieldOps);
        this.updateAllOpDialect();
    }

    public synchronized void addFieldOp(FieldOp fieldOp) {
        if (fieldOp != null) {
            this.fieldOps.add(fieldOp);
            this.updateOpDialect(fieldOp);
        }
    }

    @Override
    public synchronized void setDialect(Dialect dialect) {
        if (dialect != null) {
            super.setDialect(dialect);
            this.updateAllOpDialect();
        }
    }

    private void updateAllOpDialect() {
        for (FieldOp op : this.fieldOps) {
            this.updateOpDialect(op);
        }
    }

    private void updateOpDialect(FieldOp op) {
        Dialect dialect;
        if (op instanceof DialectSensor && (dialect = this.getDialect()) != null) {
            ((DialectSensor)((Object)op)).setDialect(dialect);
        }
    }
}

