/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.group;

import com.ejlchina.searcher.group.ExprParser;
import com.ejlchina.searcher.group.Group;
import com.ejlchina.searcher.util.StringUtils;
import java.util.Stack;

public class DefaultExprParser
implements ExprParser {
    private final String expression;
    private final Stack<Group<String>> valueStack = new Stack();
    private final Stack<Character> opStack = new Stack();
    private final char andOp;
    private final char orOp;
    private int index = 0;

    public DefaultExprParser(String expression, char andOp, char orOp) {
        this.expression = expression;
        this.andOp = andOp;
        this.orOp = orOp;
    }

    @Override
    public Group<String> parse() {
        Object res = this.readNext();
        while (res != null) {
            if (res instanceof String) {
                String value = (String)res;
                if (StringUtils.isNotBlank(value)) {
                    this.valueStack.push(new Group<String>(value));
                }
            } else if (res instanceof Character) {
                this.onReadOperator(((Character)res).charValue());
            }
            res = this.readNext();
        }
        return this.getResult();
    }

    protected Object readNext() {
        int initIndex = this.index;
        while (this.index < this.expression.length()) {
            char ch = this.expression.charAt(this.index);
            if (ch == this.andOp || ch == this.orOp || ch == '(' || ch == ')') {
                if (this.index == initIndex) {
                    ++this.index;
                    return Character.valueOf(ch);
                }
                return this.expression.substring(initIndex, this.index).trim();
            }
            ++this.index;
        }
        if (this.index > initIndex) {
            return this.expression.substring(initIndex, this.index).trim();
        }
        return null;
    }

    protected void onReadOperator(char op) {
        if (op != '(') {
            while (this.opStack.size() > 0) {
                char topOp = this.opStack.pop().charValue();
                if (op == ')') {
                    if (topOp == '(') {
                        return;
                    }
                } else if (topOp == '(' || op == this.andOp && topOp == this.orOp) {
                    this.opStack.push(Character.valueOf(topOp));
                    break;
                }
                this.updateValueStack(topOp);
            }
        }
        this.opStack.push(Character.valueOf(op));
    }

    protected void updateValueStack(char op) {
        Group<String> value2 = this.valueStack.pop();
        Group<String> value1 = this.valueStack.pop();
        if (op == this.andOp) {
            this.valueStack.push(value1.and(value2));
        } else if (op == this.orOp) {
            this.valueStack.push(value1.or(value2));
        } else {
            throw new IllegalStateException("invalid expr");
        }
    }

    protected Group<String> getResult() {
        while (this.opStack.size() > 0) {
            char op = this.opStack.pop().charValue();
            this.updateValueStack(op);
        }
        return this.valueStack.pop();
    }
}

