/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.ParamFilter;
import com.ejlchina.searcher.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BoolValueFilter
implements ParamFilter {
    private String separator = "-";
    private String trueSuffix = "true";
    private String falseSuffix = "false";
    private String ignoreCaseSuffix = "ic";
    private String[] falseValues = new String[]{"0", "OFF", "FALSE", "N", "NO", "F"};

    @Override
    public <T> Map<String, Object> doFilter(BeanMeta<T> beanMeta, Map<String, Object> paraMap) {
        String[] fields = this.getBoolFieldList(beanMeta);
        String icSuffix = this.separator + this.ignoreCaseSuffix;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : paraMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.endsWith(icSuffix)) {
                map.put(key, this.toBoolean(value));
                continue;
            }
            String field = this.findField(fields, key);
            if (field == null) {
                map.put(key, value);
                continue;
            }
            if (key.length() == field.length()) {
                map.put(field, this.toBoolean(value));
                continue;
            }
            map.put(field, key.endsWith(this.trueSuffix));
        }
        return map;
    }

    protected String[] getBoolFieldList(BeanMeta<?> beanMeta) {
        return (String[])beanMeta.getFieldMetas().stream().filter(meta -> {
            Class<?> type = meta.getType();
            return type == Boolean.TYPE || type == Boolean.class;
        }).map(FieldMeta::getName).toArray(String[]::new);
    }

    protected String findField(String[] fields, String key) {
        for (String field : fields) {
            int len;
            if (!key.startsWith(field)) continue;
            int fLen = field.length();
            if (key.length() == fLen) {
                return field;
            }
            String suffix = key.substring(fLen);
            if (!suffix.startsWith(this.separator) || ((len = suffix.length() - this.separator.length()) != this.falseSuffix.length() || !suffix.endsWith(this.falseSuffix)) && (len != this.trueSuffix.length() || !suffix.endsWith(this.trueSuffix))) continue;
            return field;
        }
        return null;
    }

    protected Boolean toBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String tv = ((String)value).trim();
            if (StringUtils.isBlank(tv)) {
                return null;
            }
            for (String fv : this.falseValues) {
                if (!tv.equalsIgnoreCase(fv)) continue;
                return Boolean.FALSE;
            }
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        return Boolean.TRUE;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = Objects.requireNonNull(separator);
    }

    public String getTrueSuffix() {
        return this.trueSuffix;
    }

    public void setTrueSuffix(String trueSuffix) {
        this.trueSuffix = Objects.requireNonNull(trueSuffix);
    }

    public String getFalseSuffix() {
        return this.falseSuffix;
    }

    public void setFalseSuffix(String falseSuffix) {
        this.falseSuffix = Objects.requireNonNull(falseSuffix);
    }

    public String getIgnoreCaseSuffix() {
        return this.ignoreCaseSuffix;
    }

    public void setIgnoreCaseSuffix(String ignoreCaseSuffix) {
        this.ignoreCaseSuffix = Objects.requireNonNull(ignoreCaseSuffix);
    }

    public String[] getFalseValues() {
        return this.falseValues;
    }

    public void setFalseValues(String[] falseValues) {
        this.falseValues = Objects.requireNonNull(falseValues);
    }
}

