/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.FieldConvertor;
import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.MapSearcher;
import com.ejlchina.searcher.ResultFilter;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchResult;
import com.ejlchina.searcher.SearchSql;
import com.ejlchina.searcher.SqlExecutor;
import com.ejlchina.searcher.SqlResult;
import com.ejlchina.searcher.implement.AbstractSearcher;
import com.ejlchina.searcher.param.FetchType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DefaultMapSearcher
extends AbstractSearcher
implements MapSearcher {
    private List<FieldConvertor.MFieldConvertor> convertors = new ArrayList<FieldConvertor.MFieldConvertor>();
    private List<ResultFilter> resultFilters = new ArrayList<ResultFilter>();

    public DefaultMapSearcher() {
    }

    public DefaultMapSearcher(SqlExecutor sqlExecutor) {
        super(sqlExecutor);
    }

    @Override
    public <T> SearchResult<Map<String, Object>> search(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(0));
    }

    @Override
    public <T> SearchResult<Map<String, Object>> search(Class<T> beanClass, Map<String, Object> paraMap, String[] summaryFields) {
        return this.search(beanClass, paraMap, new FetchType(0, summaryFields));
    }

    @Override
    public <T> Map<String, Object> searchFirst(Class<T> beanClass, Map<String, Object> paraMap) {
        FetchType fetchType = new FetchType(1);
        List<Map<String, Object>> list = this.search(beanClass, paraMap, fetchType).getDataList();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> List<Map<String, Object>> searchList(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(2)).getDataList();
    }

    @Override
    public <T> List<Map<String, Object>> searchAll(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(3)).getDataList();
    }

    protected <T> SearchResult<Map<String, Object>> search(Class<T> beanClass, Map<String, Object> paraMap, FetchType fetchType) {
        SqlResult<T> sqlResult = this.doSearch(beanClass, paraMap, fetchType);
        try {
            SearchSql<T> searchSql = sqlResult.getSearchSql();
            BeanMeta<T> beanMeta = searchSql.getBeanMeta();
            SqlResult.ResultSet listResult = sqlResult.getListResult();
            SearchResult<Map<String, Object>> result = new SearchResult<Map<String, Object>>();
            if (listResult != null) {
                List<String> fetchFields = searchSql.getFetchFields();
                while (listResult.next()) {
                    HashMap<String, Object> data = new HashMap<String, Object>(fetchFields.size());
                    for (String field : fetchFields) {
                        FieldMeta meta = beanMeta.requireFieldMeta(field);
                        Object value = listResult.get(meta.getDbAlias());
                        data.put(meta.getName(), this.convert(meta, value));
                    }
                    result.addData(data);
                }
            }
            if (searchSql.isShouldQueryCluster()) {
                result.setTotalCount(this.getCountFromSqlResult(sqlResult));
                result.setSummaries(this.getSummaryFromSqlResult(sqlResult));
            }
            SearchResult<Map<String, Object>> searchResult = this.doFilter(result, beanMeta, paraMap, fetchType);
            if (sqlResult != null) {
                sqlResult.close();
            }
            return searchResult;
        }
        catch (Throwable throwable) {
            try {
                if (sqlResult != null) {
                    try {
                        sqlResult.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new SearchException("A exception occurred when collecting sql result!", e);
            }
        }
    }

    protected Object convert(FieldMeta meta, Object value) {
        if (value != null && this.convertors.size() > 0) {
            Class<?> valueType = value.getClass();
            for (FieldConvertor fieldConvertor : this.convertors) {
                if (!fieldConvertor.supports(meta, valueType)) continue;
                return fieldConvertor.convert(meta, value);
            }
        }
        return value;
    }

    protected <T> SearchResult<Map<String, Object>> doFilter(SearchResult<Map<String, Object>> result, BeanMeta<T> beanMeta, Map<String, Object> paraMap, FetchType fetchType) {
        for (ResultFilter filter : this.resultFilters) {
            result = filter.doMapFilter(result, beanMeta, paraMap, fetchType);
        }
        return result;
    }

    public List<FieldConvertor.MFieldConvertor> getConvertors() {
        return this.convertors;
    }

    public void setConvertors(List<FieldConvertor.MFieldConvertor> convertors) {
        this.convertors = Objects.requireNonNull(convertors);
    }

    public void addConvertor(FieldConvertor.MFieldConvertor convertor) {
        if (convertor != null) {
            this.convertors.add(convertor);
        }
    }

    public List<ResultFilter> getResultFilters() {
        return this.resultFilters;
    }

    public void setResultFilters(List<ResultFilter> resultFilters) {
        this.resultFilters = Objects.requireNonNull(resultFilters);
    }

    public void addResultFilter(ResultFilter resultFilter) {
        if (resultFilter != null) {
            this.resultFilters.add(resultFilter);
        }
    }
}

