/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.util;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MapWrapper {
    private final Map<String, Object> map;
    private final String prefix;
    private final String gKey;
    transient Set<String> keySet;

    public MapWrapper(Map<String, Object> map) {
        this(map, null, null);
    }

    public MapWrapper(Map<String, Object> map, String gKey, String separator) {
        this.map = Objects.requireNonNull(map);
        this.prefix = gKey != null ? gKey + separator : null;
        this.gKey = gKey;
    }

    public Set<String> keySet() {
        Set<String> ks = this.keySet;
        if (ks == null) {
            if (this.prefix != null) {
                int index = this.prefix.length();
                ks = this.map.keySet().stream().map(k -> {
                    if (k.startsWith(this.prefix)) {
                        return k.substring(index);
                    }
                    return k;
                }).collect(Collectors.toSet());
            } else {
                ks = this.map.keySet();
            }
            this.keySet = ks;
        }
        return ks;
    }

    public Object get0(String key) {
        if (this.gKey != null) {
            return this.map.get(this.gKey + key);
        }
        return this.map.get(key);
    }

    public Object get1(String key) {
        if (this.prefix != null) {
            return this.map.get(this.prefix + key);
        }
        return this.map.get(key);
    }
}

