/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SearchResult<T> {
    public static final Number[] EMPTY_SUMMARIES = new Number[0];
    private Number totalCount = 0;
    private final List<T> dataList;
    private Number[] summaries = EMPTY_SUMMARIES;

    public SearchResult() {
        this(0, EMPTY_SUMMARIES);
    }

    public SearchResult(Number totalCount) {
        this(totalCount, EMPTY_SUMMARIES);
    }

    public SearchResult(Number totalCount, Number[] summaries) {
        this(new ArrayList(totalCount.intValue()));
        this.totalCount = totalCount;
        this.summaries = summaries;
    }

    public SearchResult(List<T> dataList) {
        this.dataList = dataList;
    }

    public Number getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Number totalCount) {
        this.totalCount = Objects.requireNonNull(totalCount);
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public void addData(T data) {
        this.dataList.add(data);
    }

    public Number[] getSummaries() {
        return this.summaries;
    }

    public void setSummaries(Number[] summaries) {
        this.summaries = Objects.requireNonNull(summaries);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("totalCount = " + this.totalCount + "\n");
        for (T data : this.dataList) {
            str.append("\t").append(data.toString());
        }
        return str.toString();
    }
}

