/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.MetaResolver;
import com.ejlchina.searcher.ParamResolver;
import com.ejlchina.searcher.ResultFilter;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchParam;
import com.ejlchina.searcher.SearchResult;
import com.ejlchina.searcher.SearchSql;
import com.ejlchina.searcher.Searcher;
import com.ejlchina.searcher.SqlExecutor;
import com.ejlchina.searcher.SqlInterceptor;
import com.ejlchina.searcher.SqlResolver;
import com.ejlchina.searcher.SqlResult;
import com.ejlchina.searcher.implement.DefaultMetaResolver;
import com.ejlchina.searcher.implement.DefaultParamResolver;
import com.ejlchina.searcher.implement.DefaultSqlResolver;
import com.ejlchina.searcher.param.FetchType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractSearcher
implements Searcher {
    private SqlExecutor sqlExecutor;
    private ParamResolver paramResolver = new DefaultParamResolver();
    private SqlResolver sqlResolver = new DefaultSqlResolver();
    private MetaResolver metaResolver = new DefaultMetaResolver();
    private List<SqlInterceptor> interceptors = new ArrayList<SqlInterceptor>();
    private List<ResultFilter> resultFilters = new ArrayList<ResultFilter>();

    public AbstractSearcher() {
    }

    public AbstractSearcher(SqlExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Number searchCount(Class<T> beanClass, Map<String, Object> paraMap) {
        try (SqlResult<T> result = this.doSearch(beanClass, paraMap, new FetchType(4));){
            Number number = this.getCountFromSqlResult(result);
            return number;
        }
        catch (SQLException e) {
            throw new SearchException("A exception occurred when collect sql result!", e);
        }
    }

    @Override
    public <T> Number searchSum(Class<T> beanClass, Map<String, Object> paraMap, String field) {
        String[] fields = new String[]{Objects.requireNonNull(field)};
        Number[] results = this.searchSum(beanClass, paraMap, fields);
        return results != null && results.length > 0 ? (Number)results[0] : (Number)0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Number[] searchSum(Class<T> beanClass, Map<String, Object> paraMap, String[] fields) {
        if (fields == null) throw new SearchException("\u68c0\u7d22\u8be5 Bean\u3010" + beanClass.getName() + "\u3011\u7684\u7edf\u8ba1\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u8981\u6307\u5b9a\u9700\u8981\u7edf\u8ba1\u7684\u5c5e\u6027\uff01");
        if (fields.length == 0) {
            throw new SearchException("\u68c0\u7d22\u8be5 Bean\u3010" + beanClass.getName() + "\u3011\u7684\u7edf\u8ba1\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u8981\u6307\u5b9a\u9700\u8981\u7edf\u8ba1\u7684\u5c5e\u6027\uff01");
        }
        try (SqlResult<T> result = this.doSearch(beanClass, paraMap, new FetchType(5, fields));){
            Number[] numberArray = this.getSummaryFromSqlResult(result);
            return numberArray;
        }
        catch (SQLException e) {
            throw new SearchException("A exception occurred when collect sql result!", e);
        }
    }

    protected Number getCountFromSqlResult(SqlResult<?> sqlResult) throws SQLException {
        Number count = (Number)sqlResult.getClusterResult().get(sqlResult.getSearchSql().getCountAlias());
        return count != null ? (Number)count : (Number)0L;
    }

    protected Number[] getSummaryFromSqlResult(SqlResult<?> sqlResult) throws SQLException {
        List<String> summaryAliases = sqlResult.getSearchSql().getSummaryAliases();
        if (summaryAliases.isEmpty()) {
            return SearchResult.EMPTY_SUMMARIES;
        }
        SqlResult.Result clusterResult = sqlResult.getClusterResult();
        Number[] summaries = new Number[summaryAliases.size()];
        for (int i = 0; i < summaries.length; ++i) {
            String summaryAlias = summaryAliases.get(i);
            Number sum = (Number)clusterResult.get(summaryAlias);
            summaries[i] = sum != null ? (Number)sum : (Number)0L;
        }
        return summaries;
    }

    protected <T> SqlResult<T> doSearch(Class<T> beanClass, Map<String, Object> paraMap, FetchType fetchType) {
        if (this.sqlExecutor == null) {
            throw new SearchException("you must set a sqlExecutor before search.");
        }
        BeanMeta<T> beanMeta = this.metaResolver.resolve(beanClass);
        SearchParam searchParam = this.paramResolver.resolve(beanMeta, fetchType, paraMap);
        SearchSql<T> searchSql = this.sqlResolver.resolve(beanMeta, searchParam);
        return this.sqlExecutor.execute(this.intercept(searchSql, paraMap, fetchType));
    }

    protected <T> SearchSql<T> intercept(SearchSql<T> searchSql, Map<String, Object> paraMap, FetchType fetchType) {
        for (SqlInterceptor interceptor : this.interceptors) {
            searchSql = interceptor.intercept(searchSql, paraMap, fetchType);
        }
        return searchSql;
    }

    public ParamResolver getParamResolver() {
        return this.paramResolver;
    }

    public void setParamResolver(ParamResolver paramResolver) {
        this.paramResolver = Objects.requireNonNull(paramResolver);
    }

    public SqlResolver getSqlResolver() {
        return this.sqlResolver;
    }

    public void setSqlResolver(SqlResolver sqlResolver) {
        this.sqlResolver = Objects.requireNonNull(sqlResolver);
    }

    public SqlExecutor getSqlExecutor() {
        return this.sqlExecutor;
    }

    public void setSqlExecutor(SqlExecutor sqlExecutor) {
        this.sqlExecutor = Objects.requireNonNull(sqlExecutor);
    }

    public MetaResolver getMetaResolver() {
        return this.metaResolver;
    }

    public void setMetaResolver(MetaResolver metaResolver) {
        this.metaResolver = Objects.requireNonNull(metaResolver);
    }

    public List<SqlInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<SqlInterceptor> interceptors) {
        this.interceptors = Objects.requireNonNull(interceptors);
    }

    public List<ResultFilter> getResultFilters() {
        return this.resultFilters;
    }

    public void setResultFilters(List<ResultFilter> resultFilters) {
        this.resultFilters = Objects.requireNonNull(resultFilters);
    }

    public void addResultFilter(ResultFilter resultFilter) {
        if (resultFilter != null) {
            this.resultFilters.add(resultFilter);
        }
    }
}

