/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.PageExtractor;
import com.ejlchina.searcher.param.Paging;
import com.ejlchina.searcher.util.MapBuilder;
import com.ejlchina.searcher.util.ObjectUtils;
import java.util.Map;

public abstract class BasePageExtractor
implements PageExtractor {
    private int start = 0;
    private String sizeName = "size";
    private int maxAllowedSize = 100;
    private int defaultSize = 15;

    @Override
    public Paging extract(Map<String, Object> paraMap) {
        Object value = paraMap.get(MapBuilder.PAGING);
        if (value instanceof MapBuilder.Page) {
            return this.toPaging((MapBuilder.Page)value);
        }
        if (value instanceof MapBuilder.Limit) {
            return this.toPaging((MapBuilder.Limit)value);
        }
        int size = this.toSize(paraMap.get(this.getSizeName()));
        return new Paging(size, this.toOffset(paraMap, size));
    }

    protected abstract long toOffset(Map<String, Object> var1, int var2);

    protected int toSize(Object value) {
        Integer size = ObjectUtils.toInt(value);
        if (size == null) {
            return this.defaultSize;
        }
        return this.allowSize(size);
    }

    protected int allowSize(int size) {
        return Math.min(Math.max(size, 0), this.maxAllowedSize);
    }

    protected Paging toPaging(MapBuilder.Page page) {
        int size = this.allowSize(page.getSize());
        long pageNo = Math.max(page.getPage() - (long)this.start, 0L);
        return new Paging(size, (long)size * pageNo);
    }

    protected Paging toPaging(MapBuilder.Limit limit) {
        int size = this.allowSize(limit.getSize());
        long offset = Math.max(limit.getOffset() - (long)this.start, 0L);
        return new Paging(size, offset);
    }

    @Override
    public String getSizeName() {
        return this.sizeName;
    }

    public int getStart() {
        return this.start;
    }

    public void setSizeName(String sizeName) {
        this.sizeName = sizeName;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setMaxAllowedSize(int maxAllowedSize) {
        this.maxAllowedSize = maxAllowedSize;
    }

    public int getMaxAllowedSize() {
        return this.maxAllowedSize;
    }

    public int getDefaultSize() {
        return this.defaultSize;
    }

    public void setDefaultSize(int defaultSize) {
        this.defaultSize = defaultSize;
    }
}

