/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.FieldConvertor;
import com.ejlchina.searcher.FieldMeta;

public class BoolNumFieldConvertor
implements FieldConvertor.BFieldConvertor {
    private static final Integer I0 = 0;
    private static final Integer I1 = 1;
    private static final Long L0 = 0L;
    private static final Long L1 = 1L;
    private static final Short S0 = 0;
    private static final Short S1 = 1;
    private static final Byte B0 = 0;
    private static final Byte B1 = 1;

    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType) {
        if (Boolean.class == valueType) {
            Class<?> targetType = meta.getType();
            return targetType == Integer.TYPE || targetType == Integer.class || targetType == Long.TYPE || targetType == Long.class || targetType == Short.TYPE || targetType == Short.class || targetType == Byte.TYPE || targetType == Byte.class;
        }
        return false;
    }

    @Override
    public Object convert(FieldMeta meta, Object value) {
        Class<?> targetType = meta.getType();
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return (Boolean)value != false ? I1 : I0;
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            return (Boolean)value != false ? L1 : L0;
        }
        if (targetType == Short.TYPE || targetType == Short.class) {
            return (Boolean)value != false ? S1 : S0;
        }
        if (targetType == Byte.TYPE || targetType == Byte.class) {
            return (Boolean)value != false ? B1 : B0;
        }
        throw new IllegalStateException("Unsupported targetType: " + targetType);
    }
}

