/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.FieldOp;
import com.ejlchina.searcher.operator.Between;
import com.ejlchina.searcher.operator.GreaterEqual;
import com.ejlchina.searcher.operator.GreaterThan;
import com.ejlchina.searcher.operator.LessEqual;
import com.ejlchina.searcher.operator.LessThan;
import com.ejlchina.searcher.operator.NotBetween;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.regex.Pattern;

public class DateValueCorrector {
    static final Pattern DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
    static final Pattern DATE_HOUR_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}");
    static final Pattern DATE_MINUTE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}");
    private FieldOp lt = new LessThan();
    private FieldOp ge = new GreaterEqual();
    private FieldOp le = new LessEqual();
    private FieldOp gt = new GreaterThan();
    private FieldOp bt = new Between();
    private FieldOp nb = new NotBetween();

    public Object[] correct(Class<?> fieldType, Object[] dateValues, FieldOp operator) {
        int i;
        if (!Date.class.isAssignableFrom(fieldType) && LocalDateTime.class != fieldType) {
            return dateValues;
        }
        if (operator.sameTo(this.lt) || operator.sameTo(this.ge)) {
            for (i = 0; i < dateValues.length; ++i) {
                dateValues[i] = this.dateValue(dateValues[i], true);
            }
        }
        if (operator.sameTo(this.le) || operator.sameTo(this.gt)) {
            for (i = 0; i < dateValues.length; ++i) {
                dateValues[i] = this.dateValue(dateValues[i], false);
            }
        }
        if (operator.sameTo(this.bt) || operator.sameTo(this.nb)) {
            if (dateValues.length > 0) {
                dateValues[0] = this.dateValue(dateValues[0], true);
            }
            if (dateValues.length > 1) {
                dateValues[1] = this.dateValue(dateValues[1], false);
            }
        }
        return dateValues;
    }

    protected Object dateValue(Object value, boolean roundDown) {
        if (value instanceof String) {
            String strValue = (String)value;
            if (DATE_PATTERN.matcher(strValue).matches()) {
                if (roundDown) {
                    return strValue + " 00:00:00";
                }
                return strValue + " 23:59:59";
            }
            if (DATE_HOUR_PATTERN.matcher(strValue).matches()) {
                if (roundDown) {
                    return strValue + ":00:00";
                }
                return strValue + ":59:59";
            }
            if (DATE_MINUTE_PATTERN.matcher(strValue).matches()) {
                if (roundDown) {
                    return strValue + ":00";
                }
                return strValue + ":59";
            }
        }
        return value;
    }

    public FieldOp getLt() {
        return this.lt;
    }

    public void setLt(FieldOp lt) {
        this.lt = lt;
    }

    public FieldOp getGe() {
        return this.ge;
    }

    public void setGe(FieldOp ge) {
        this.ge = ge;
    }

    public FieldOp getLe() {
        return this.le;
    }

    public void setLe(FieldOp le) {
        this.le = le;
    }

    public FieldOp getGt() {
        return this.gt;
    }

    public void setGt(FieldOp gt) {
        this.gt = gt;
    }

    public FieldOp getBt() {
        return this.bt;
    }

    public void setBt(FieldOp bt) {
        this.bt = bt;
    }

    public FieldOp getNb() {
        return this.nb;
    }

    public void setNb(FieldOp nb) {
        this.nb = nb;
    }
}

