/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.BeanReflector;
import com.ejlchina.searcher.FieldConvertor;
import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.SearchException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class DefaultBeanReflector
implements BeanReflector {
    private List<FieldConvertor.BFieldConvertor> convertors;

    public DefaultBeanReflector() {
        this(new ArrayList<FieldConvertor.BFieldConvertor>());
    }

    public DefaultBeanReflector(List<FieldConvertor.BFieldConvertor> convertors) {
        this.convertors = convertors;
    }

    @Override
    public <T> T reflect(BeanMeta<T> beanMeta, Collection<FieldMeta> fetchFields, Function<String, Object> valueGetter) {
        Class<T> beanClass = beanMeta.getBeanClass();
        T bean = this.newInstance(beanClass);
        for (FieldMeta meta : fetchFields) {
            Object value = valueGetter.apply(meta.getDbAlias());
            try {
                value = this.convert(meta, value);
            }
            catch (Exception e) {
                throw new SearchException("The type of [" + beanClass + "#" + meta.getName() + "] is mismatch with it's database table field type", e);
            }
            if (value == null) continue;
            try {
                meta.getField().set(bean, value);
            }
            catch (ReflectiveOperationException e) {
                throw new SearchException("A exception occurred when setting value to [" + beanClass.getName() + "#" + meta.getName() + "], please check whether it's setter is correct.", e);
            }
        }
        return bean;
    }

    protected Object convert(FieldMeta meta, Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueType = value.getClass();
        Class<?> targetType = meta.getType();
        if (targetType.isAssignableFrom(valueType)) {
            return value;
        }
        for (FieldConvertor fieldConvertor : this.convertors) {
            if (!fieldConvertor.supports(meta, valueType)) continue;
            return fieldConvertor.convert(meta, value);
        }
        throw new SearchException("\u4e0d\u80fd\u628a\u3010" + valueType + "\u3011\u7c7b\u578b\u7684\u6570\u636e\u5e93\u503c\u8f6c\u6362\u4e3a\u3010" + targetType + "\u3011\u7c7b\u578b\u7684\u5b57\u6bb5\u503c\uff0c\u4f60\u53ef\u4ee5\u6dfb\u52a0\u4e00\u4e2a BFieldConvertor \u6765\u8f6c\u6362\u5b83\uff01");
    }

    protected <T> T newInstance(Class<T> beanClass) {
        try {
            return beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SearchException("\u4e3a\u3010" + beanClass.getName() + "\u3011\u521b\u5efa\u5bf9\u8c61\u65f6\u62a5\u9519\uff0c\u8bf7\u68c0\u67e5\u8be5\u7c7b\u4e2d\u662f\u5426\u6709\u65e0\u53c2\u6784\u9020\u65b9\u6cd5\uff01", e);
        }
    }

    public List<FieldConvertor.BFieldConvertor> getConvertors() {
        return this.convertors;
    }

    public void setConvertors(List<FieldConvertor.BFieldConvertor> convertors) {
        this.convertors = Objects.requireNonNull(convertors);
    }

    public void addConvertor(FieldConvertor.BFieldConvertor convertor) {
        if (convertor != null) {
            this.convertors.add(convertor);
        }
    }
}

