/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.FieldConvertor;
import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.MapSearcher;
import com.ejlchina.searcher.ResultFilter;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchResult;
import com.ejlchina.searcher.SearchSql;
import com.ejlchina.searcher.SqlExecutor;
import com.ejlchina.searcher.SqlResult;
import com.ejlchina.searcher.implement.AbstractSearcher;
import com.ejlchina.searcher.param.FetchType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultMapSearcher
extends AbstractSearcher
implements MapSearcher {
    private List<FieldConvertor.MFieldConvertor> convertors = new ArrayList<FieldConvertor.MFieldConvertor>();

    public DefaultMapSearcher() {
    }

    public DefaultMapSearcher(SqlExecutor sqlExecutor) {
        super(sqlExecutor);
    }

    @Override
    public <T> SearchResult<Map<String, Object>> search(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(0));
    }

    @Override
    public <T> SearchResult<Map<String, Object>> search(Class<T> beanClass, Map<String, Object> paraMap, String[] summaryFields) {
        return this.search(beanClass, paraMap, new FetchType(0, summaryFields));
    }

    @Override
    public <T> Map<String, Object> searchFirst(Class<T> beanClass, Map<String, Object> paraMap) {
        FetchType fetchType = new FetchType(1);
        List<Map<String, Object>> list = this.search(beanClass, paraMap, fetchType).getDataList();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> List<Map<String, Object>> searchList(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(2)).getDataList();
    }

    @Override
    public <T> List<Map<String, Object>> searchAll(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(3)).getDataList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> SearchResult<Map<String, Object>> search(Class<T> beanClass, Map<String, Object> paraMap, FetchType fetchType) {
        try (SqlResult<T> sqlResult = this.doSearch(beanClass, paraMap, fetchType);){
            SearchSql<T> searchSql = sqlResult.getSearchSql();
            Number totalCount = 0L;
            Number[] summaries = SearchResult.EMPTY_SUMMARIES;
            if (searchSql.isShouldQueryCluster()) {
                totalCount = this.getCountFromSqlResult(sqlResult);
                summaries = this.getSummaryFromSqlResult(sqlResult);
            }
            SearchResult<Map<String, Object>> result = new SearchResult<Map<String, Object>>(totalCount, summaries);
            BeanMeta<T> beanMeta = searchSql.getBeanMeta();
            SqlResult.ResultSet listResult = sqlResult.getListResult();
            if (listResult != null) {
                List fieldMetas = searchSql.getFetchFields().stream().map(beanMeta::requireFieldMeta).collect(Collectors.toList());
                List<Map<String, Object>> dataList = result.getDataList();
                while (listResult.next()) {
                    HashMap<String, Object> data = new HashMap<String, Object>(fieldMetas.size());
                    for (FieldMeta meta : fieldMetas) {
                        Object value = listResult.get(meta.getDbAlias());
                        data.put(meta.getName(), this.convert(meta, value));
                    }
                    dataList.add(data);
                }
            }
            SearchResult<Map<String, Object>> searchResult = this.doFilter(result, beanMeta, paraMap, fetchType);
            return searchResult;
        }
        catch (SQLException e) {
            throw new SearchException("A exception occurred when collecting sql result!", e);
        }
    }

    protected Object convert(FieldMeta meta, Object value) {
        if (value != null && this.convertors.size() > 0) {
            Class<?> valueType = value.getClass();
            for (FieldConvertor fieldConvertor : this.convertors) {
                if (!fieldConvertor.supports(meta, valueType)) continue;
                return fieldConvertor.convert(meta, value);
            }
        }
        return value;
    }

    protected <T> SearchResult<Map<String, Object>> doFilter(SearchResult<Map<String, Object>> result, BeanMeta<T> beanMeta, Map<String, Object> paraMap, FetchType fetchType) {
        for (ResultFilter filter : this.getResultFilters()) {
            result = filter.doMapFilter(result, beanMeta, paraMap, fetchType);
        }
        return result;
    }

    public List<FieldConvertor.MFieldConvertor> getConvertors() {
        return this.convertors;
    }

    public void setConvertors(List<FieldConvertor.MFieldConvertor> convertors) {
        this.convertors = Objects.requireNonNull(convertors);
    }

    public void addConvertor(FieldConvertor.MFieldConvertor convertor) {
        if (convertor != null) {
            this.convertors.add(convertor);
        }
    }
}

