/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.FieldOp;
import com.ejlchina.searcher.FieldOpPool;
import com.ejlchina.searcher.PageExtractor;
import com.ejlchina.searcher.ParamFilter;
import com.ejlchina.searcher.ParamResolver;
import com.ejlchina.searcher.SearchParam;
import com.ejlchina.searcher.group.DefaultGroupResolver;
import com.ejlchina.searcher.group.Group;
import com.ejlchina.searcher.group.GroupResolver;
import com.ejlchina.searcher.implement.BoolValueFilter;
import com.ejlchina.searcher.implement.PageSizeExtractor;
import com.ejlchina.searcher.operator.Equal;
import com.ejlchina.searcher.param.FetchType;
import com.ejlchina.searcher.param.FieldParam;
import com.ejlchina.searcher.param.Operator;
import com.ejlchina.searcher.param.OrderBy;
import com.ejlchina.searcher.param.Paging;
import com.ejlchina.searcher.util.MapBuilder;
import com.ejlchina.searcher.util.MapWrapper;
import com.ejlchina.searcher.util.ObjectUtils;
import com.ejlchina.searcher.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DefaultParamResolver
implements ParamResolver {
    public static final Pattern INDEX_PATTERN = Pattern.compile("[0-9]+");
    private PageExtractor pageExtractor = new PageSizeExtractor();
    private List<ParamFilter> paramFilters = new ArrayList<ParamFilter>();
    private FieldOpPool fieldOpPool = new FieldOpPool();
    private String sortName = "sort";
    private String orderName = "order";
    private String orderByName = "orderBy";
    private String separator = "-";
    private String ignoreCaseSuffix = "ic";
    private String operatorSuffix = "op";
    private String onlySelectName = "onlySelect";
    private String selectExcludeName = "selectExclude";
    private String gexprName = "gexpr";
    private String groupSeparator = ".";
    private GroupResolver groupResolver = new DefaultGroupResolver();

    public DefaultParamResolver() {
        this.paramFilters.add(new BoolValueFilter());
    }

    @Override
    public SearchParam resolve(BeanMeta<?> beanMeta, FetchType fetchType, Map<String, Object> paraMap) {
        for (ParamFilter filter : this.paramFilters) {
            if (paraMap == null) break;
            paraMap = filter.doFilter(beanMeta, paraMap);
        }
        if (paraMap == null) {
            paraMap = Collections.emptyMap();
        }
        return this.doResolve(beanMeta, fetchType, paraMap);
    }

    public SearchParam doResolve(BeanMeta<?> beanMeta, FetchType fetchType, Map<String, Object> paraMap) {
        List<String> fetchFields = this.resolveFetchFields(beanMeta, fetchType, paraMap);
        Group<List<FieldParam>> paramsGroup = this.resolveParamsGroup(beanMeta.getFieldMetas(), paraMap);
        Paging paging = this.resolvePaging(fetchType, paraMap);
        SearchParam searchParam = new SearchParam(paraMap, fetchType, fetchFields, paramsGroup, paging);
        if (fetchType.shouldQueryList() && beanMeta.isSortable()) {
            Set<String> fieldSet = beanMeta.getFieldSet();
            for (OrderBy orderBy : this.resolveOrderBys(paraMap)) {
                if (!orderBy.isValid(fieldSet)) continue;
                searchParam.addOrderBy(orderBy);
            }
        }
        return searchParam;
    }

    public Paging resolvePaging(FetchType fetchType, Map<String, Object> paraMap) {
        if (fetchType.canPaging()) {
            Paging paging = this.pageExtractor.extract(paraMap);
            if (fetchType.isFetchFirst()) {
                paging.setSize(1);
            }
            return paging;
        }
        return null;
    }

    public List<String> resolveFetchFields(BeanMeta<?> beanMeta, FetchType fetchType, Map<String, Object> paraMap) {
        if (fetchType.shouldQueryList() || beanMeta.isDistinctOrGroupBy()) {
            Set<String> fieldList = beanMeta.getFieldSet();
            List onlySelect = ObjectUtils.toList(this.getOnlySelect(paraMap)).stream().filter(fieldList::contains).collect(Collectors.toList());
            List<String> selectExclude = ObjectUtils.toList(this.getSelectExclude(paraMap));
            return (onlySelect.isEmpty() ? fieldList : onlySelect).stream().filter(f -> !selectExclude.contains(f)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected Object getSelectExclude(Map<String, Object> paraMap) {
        Object value = paraMap.get(MapBuilder.SELECT_EXCLUDE);
        if (value != null) {
            return value;
        }
        return paraMap.get(this.selectExcludeName);
    }

    protected Object getOnlySelect(Map<String, Object> paraMap) {
        Object value = paraMap.get(MapBuilder.ONLY_SELECT);
        if (value != null) {
            return value;
        }
        return paraMap.get(this.onlySelectName);
    }

    public Group<List<FieldParam>> resolveParamsGroup(Collection<FieldMeta> fieldMetas, Map<String, Object> paraMap) {
        HashMap holder = new HashMap();
        return this.groupResolver.resolve(this.getGroupExpr(paraMap)).transform(gKey -> {
            List<FieldParam> params = (List<FieldParam>)holder.get(gKey);
            if (params == null) {
                MapWrapper mapWrapper = gKey != null ? new MapWrapper(paraMap, (String)gKey, this.groupSeparator) : new MapWrapper(paraMap);
                params = this.extractFieldParams(fieldMetas, mapWrapper);
                holder.put(gKey, params);
            }
            return params;
        }).filter(list -> list.size() > 0);
    }

    protected String getGroupExpr(Map<String, Object> paraMap) {
        String expr = ObjectUtils.string(paraMap.get(MapBuilder.GROUP_EXPR));
        if (expr != null) {
            return expr;
        }
        return ObjectUtils.string(paraMap.get(this.gexprName));
    }

    private List<FieldParam> extractFieldParams(Collection<FieldMeta> fieldMetas, MapWrapper paraMap) {
        HashMap<String, Set<Integer>> fieldIndicesMap = new HashMap<String, Set<Integer>>();
        for (String key : paraMap.keySet()) {
            String suffix;
            int index = key.lastIndexOf(this.separator);
            if (index > 0 && key.length() > index + 1 && INDEX_PATTERN.matcher(suffix = key.substring(index + 1)).matches()) {
                String field = key.substring(0, index);
                this.mapFieldIndex(fieldIndicesMap, field, Integer.parseInt(suffix));
            }
            this.mapFieldIndex(fieldIndicesMap, key, 0);
        }
        ArrayList<FieldParam> fieldParams = new ArrayList<FieldParam>();
        for (FieldMeta meta : fieldMetas) {
            Set indices;
            FieldParam param;
            if (!meta.isConditional() || (param = this.toFieldParam(meta, indices = (Set)fieldIndicesMap.get(meta.getName()), paraMap)) == null) continue;
            fieldParams.add(param);
        }
        return fieldParams;
    }

    protected void mapFieldIndex(Map<String, Set<Integer>> fieldIndicesKeysMap, String field, int index) {
        fieldIndicesKeysMap.computeIfAbsent(field, k -> new HashSet(2)).add(index);
    }

    protected FieldParam getFieldParam(MapWrapper paraMap, String field) {
        Object value = paraMap.get0(MapBuilder.FIELD_PARAM + field);
        if (value instanceof FieldParam) {
            return (FieldParam)value;
        }
        return null;
    }

    protected FieldParam toFieldParam(FieldMeta meta, Set<Integer> indices, MapWrapper paraMap) {
        ArrayList<FieldParam.Value> values;
        FieldParam param;
        String field = meta.getName();
        FieldOp operator = this.allowedOperator(this.toOperator(field, paraMap, param = this.getFieldParam(paraMap, field)), meta.getOnlyOn());
        if (operator == null) {
            return null;
        }
        if (operator.lonely()) {
            return new FieldParam(field, operator);
        }
        if ((indices == null || indices.isEmpty()) && param == null) {
            return null;
        }
        ArrayList<FieldParam.Value> arrayList = values = param != null ? param.getValueList() : new ArrayList<FieldParam.Value>();
        if (values.isEmpty() && indices != null) {
            for (int index : indices) {
                Object value = paraMap.get1(field + this.separator + index);
                if (index == 0 && value == null) {
                    value = paraMap.get1(field);
                }
                value = this.fieldValue(meta, value);
                values.add(new FieldParam.Value(value, index));
            }
        }
        if (this.isAllEmpty(values)) {
            return null;
        }
        Boolean ignoreCase = null;
        if (param != null) {
            ignoreCase = param.isIgnoreCase();
        }
        if (ignoreCase == null) {
            ignoreCase = ObjectUtils.toBoolean(paraMap.get1(field + this.separator + this.ignoreCaseSuffix));
        }
        return new FieldParam(field, operator, values, ignoreCase);
    }

    protected Object fieldValue(FieldMeta meta, Object value) {
        String str;
        if (value == null) {
            return null;
        }
        if (value instanceof String && StringUtils.isBlank(str = (String)value)) {
            return null;
        }
        return value;
    }

    protected boolean isAllEmpty(List<FieldParam.Value> values) {
        for (FieldParam.Value value : values) {
            if (value.isEmptyValue()) continue;
            return false;
        }
        return true;
    }

    protected FieldOp toOperator(String field, MapWrapper paraMap, FieldParam param) {
        Object op;
        if (param != null && (op = param.getOperator()) != null) {
            return this.fieldOpPool.getFieldOp(op);
        }
        Object value = paraMap.get1(field + this.separator + this.operatorSuffix);
        return this.fieldOpPool.getFieldOp(value);
    }

    protected FieldOp allowedOperator(FieldOp op, Class<? extends FieldOp>[] onlyOn) {
        if (op == null) {
            Class<Equal> tOp = onlyOn.length == 0 ? Operator.Equal : onlyOn[0];
            return this.fieldOpPool.getFieldOp(tOp);
        }
        if (onlyOn.length == 0) {
            return op;
        }
        Class<?> opCls = op.getClass();
        for (Class<? extends FieldOp> clazz : onlyOn) {
            if (clazz != opCls) continue;
            return op;
        }
        return this.fieldOpPool.getFieldOp(onlyOn[0]);
    }

    public List<OrderBy> resolveOrderBys(Map<String, Object> paraMap) {
        List orderBys = (List)paraMap.get(MapBuilder.ORDER_BY);
        if (orderBys != null) {
            return orderBys;
        }
        String string = ObjectUtils.string(paraMap.get(this.orderByName));
        if (StringUtils.isNotBlank(string)) {
            return Arrays.stream(string.split(",")).map(str -> {
                String[] splits = str.split(":");
                if (splits.length == 1) {
                    return new OrderBy(splits[0], null);
                }
                if (splits.length == 2) {
                    return new OrderBy(splits[0], splits[1]);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        String sort = ObjectUtils.string(paraMap.get(this.sortName));
        String order = ObjectUtils.string(paraMap.get(this.orderName));
        if (sort != null) {
            return Collections.singletonList(new OrderBy(sort, order));
        }
        return Collections.emptyList();
    }

    public PageExtractor getPageExtractor() {
        return this.pageExtractor;
    }

    public void setPageExtractor(PageExtractor pageExtractor) {
        this.pageExtractor = Objects.requireNonNull(pageExtractor);
    }

    public void addParamFilter(ParamFilter paramFilter) {
        this.paramFilters.add(Objects.requireNonNull(paramFilter));
    }

    public void setParamFilters(List<ParamFilter> paramFilters) {
        this.paramFilters = Objects.requireNonNull(paramFilters);
    }

    public List<ParamFilter> getParamFilters() {
        return this.paramFilters;
    }

    public FieldOpPool getFieldOpPool() {
        return this.fieldOpPool;
    }

    public void setFieldOpPool(FieldOpPool fieldOpPool) {
        this.fieldOpPool = fieldOpPool;
    }

    public String getSortName() {
        return this.sortName;
    }

    public void setSortName(String sortName) {
        this.sortName = Objects.requireNonNull(sortName);
    }

    public String getOrderName() {
        return this.orderName;
    }

    public void setOrderName(String orderName) {
        this.orderName = Objects.requireNonNull(orderName);
    }

    public String getOrderByName() {
        return this.orderByName;
    }

    public void setOrderByName(String orderByName) {
        this.orderByName = orderByName;
    }

    public String getIgnoreCaseSuffix() {
        return this.ignoreCaseSuffix;
    }

    public void setIgnoreCaseSuffix(String ignoreCaseSuffix) {
        this.ignoreCaseSuffix = Objects.requireNonNull(ignoreCaseSuffix);
    }

    public String getOperatorSuffix() {
        return this.operatorSuffix;
    }

    public void setOperatorSuffix(String operatorSuffix) {
        this.operatorSuffix = Objects.requireNonNull(operatorSuffix);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = Objects.requireNonNull(separator);
    }

    public String getOnlySelectName() {
        return this.onlySelectName;
    }

    public void setOnlySelectName(String onlySelectName) {
        this.onlySelectName = Objects.requireNonNull(onlySelectName);
    }

    public String getSelectExcludeName() {
        return this.selectExcludeName;
    }

    public void setSelectExcludeName(String selectExcludeName) {
        this.selectExcludeName = Objects.requireNonNull(selectExcludeName);
    }

    public String getGexprName() {
        return this.gexprName;
    }

    public void setGexprName(String gexprName) {
        this.gexprName = gexprName;
    }

    public GroupResolver getGroupResolver() {
        return this.groupResolver;
    }

    public void setGroupResolver(GroupResolver groupResolver) {
        this.groupResolver = Objects.requireNonNull(groupResolver);
    }

    public String getGroupSeparator() {
        return this.groupSeparator;
    }

    public void setGroupSeparator(String groupSeparator) {
        this.groupSeparator = Objects.requireNonNull(groupSeparator);
    }
}

