/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchSql;
import com.ejlchina.searcher.SqlExecutor;
import com.ejlchina.searcher.SqlResult;
import com.ejlchina.searcher.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSqlExecutor
implements SqlExecutor {
    protected static final Logger log = LoggerFactory.getLogger(DefaultSqlExecutor.class);
    private DataSource dataSource;
    private final Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();
    private boolean transactional = false;
    private int transactionIsolation = 2;
    private long slowSqlThreshold = 500L;
    private SqlExecutor.SlowListener slowListener;

    public DefaultSqlExecutor() {
    }

    public DefaultSqlExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public <T> SqlResult<T> execute(SearchSql<T> searchSql) {
        Connection connection;
        if (!searchSql.isShouldQueryList() && !searchSql.isShouldQueryCluster()) {
            return new SqlResult<T>(searchSql);
        }
        try {
            connection = this.getConnection(searchSql.getBeanMeta());
        }
        catch (SQLException e) {
            throw new SearchException("Can not get connection from dataSource!", e);
        }
        try {
            return this.doExecute(searchSql, connection);
        }
        catch (SQLException e) {
            DefaultSqlExecutor.closeQuietly(connection);
            throw new SearchException("A exception occurred when query!", e);
        }
    }

    protected Connection getConnection(BeanMeta<?> beanMeta) throws SQLException {
        String name = beanMeta.getDataSource();
        if (StringUtils.isBlank(name)) {
            if (this.dataSource == null) {
                throw new SearchException("There is no default dataSource for " + beanMeta.getBeanClass());
            }
            return this.dataSource.getConnection();
        }
        DataSource dataSource = this.dataSourceMap.get(name);
        if (dataSource == null) {
            throw new SearchException("There is no dataSource named " + name + " for " + beanMeta.getBeanClass());
        }
        return dataSource.getConnection();
    }

    protected <T> SqlResult<T> doExecute(SearchSql<T> searchSql, final Connection connection) throws SQLException {
        if (this.transactional) {
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(this.transactionIsolation);
            connection.setReadOnly(true);
        }
        SqlResult.ResultSet listResult = null;
        SqlResult.Result clusterResult = null;
        try {
            Number totalCount = null;
            if (searchSql.isShouldQueryCluster()) {
                clusterResult = this.executeClusterSql(searchSql, connection);
                String countAlias = searchSql.getCountAlias();
                if (countAlias != null) {
                    totalCount = (Number)clusterResult.get(countAlias);
                }
            }
            if (searchSql.isShouldQueryList()) {
                listResult = totalCount == null || totalCount.longValue() > 0L ? this.executeListSql(searchSql, connection) : SqlResult.ResultSet.EMPTY;
            }
        }
        catch (SQLException e) {
            DefaultSqlExecutor.closeQuietly(clusterResult);
            throw e;
        }
        finally {
            if (this.transactional) {
                connection.commit();
                connection.setReadOnly(false);
            }
        }
        return new SqlResult<T>(searchSql, listResult, clusterResult){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    DefaultSqlExecutor.closeQuietly(connection);
                }
            }
        };
    }

    protected SqlResult.ResultSet executeListSql(SearchSql<?> searchSql, Connection connection) throws SQLException {
        final Result result = this.executeQuery(connection, searchSql.getListSqlString(), searchSql.getListSqlParams(), searchSql);
        final ResultSet resultSet = result.resultSet;
        return new SqlResult.ResultSet(){

            @Override
            public boolean next() throws SQLException {
                return resultSet.next();
            }

            @Override
            public Object get(String columnLabel) throws SQLException {
                return resultSet.getObject(columnLabel);
            }

            @Override
            public void close() {
                result.close();
            }
        };
    }

    protected SqlResult.Result executeClusterSql(SearchSql<?> searchSql, Connection connection) throws SQLException {
        boolean hasValue;
        final Result result = this.executeQuery(connection, searchSql.getClusterSqlString(), searchSql.getClusterSqlParams(), searchSql);
        final ResultSet resultSet = result.resultSet;
        try {
            hasValue = resultSet.next();
        }
        catch (SQLException e) {
            result.close();
            throw e;
        }
        return new SqlResult.Result(){

            @Override
            public Object get(String columnLabel) throws SQLException {
                if (hasValue) {
                    return resultSet.getObject(columnLabel);
                }
                return null;
            }

            @Override
            public void close() {
                result.close();
            }
        };
    }

    protected Result executeQuery(Connection connection, String sql, List<Object> params, SearchSql<?> searchSql) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            statement.setObject(i + 1, params.get(i));
        }
        long t0 = System.currentTimeMillis();
        try {
            ResultSet resultSet = statement.executeQuery();
            Result result = new Result(statement, resultSet);
            return result;
        }
        catch (SQLException e) {
            DefaultSqlExecutor.closeQuietly(statement);
            throw e;
        }
        finally {
            long cost = System.currentTimeMillis() - t0;
            this.afterExecute(searchSql, sql, params, cost);
        }
    }

    protected void afterExecute(SearchSql<?> searchSql, String sql, List<Object> params, long timeCost) {
        if (timeCost >= this.slowSqlThreshold) {
            Class<?> beanClass = searchSql.getBeanMeta().getBeanClass();
            SqlExecutor.SlowListener listener = this.slowListener;
            if (listener != null) {
                listener.onSlowSql(beanClass, sql, params, timeCost);
            }
            log.warn("bean-searcher [{}ms] slow-sql: [{}] params: {} on [{}]", new Object[]{timeCost, sql, params, beanClass.getName()});
        } else {
            log.debug("bean-searcher [{}ms] sql: [{}] params: {}", new Object[]{timeCost, sql, params});
        }
    }

    protected static void closeQuietly(AutoCloseable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Exception e) {
            log.error("Can not close {}", (Object)resource.getClass().getSimpleName(), (Object)e);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = Objects.requireNonNull(dataSource);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String name, DataSource dataSource) {
        if (name != null && dataSource != null) {
            this.dataSourceMap.put(name.trim(), dataSource);
        }
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int level) {
        this.transactionIsolation = level;
    }

    public long getSlowSqlThreshold() {
        return this.slowSqlThreshold;
    }

    public void setSlowSqlThreshold(long slowSqlThreshold) {
        this.slowSqlThreshold = slowSqlThreshold;
    }

    public SqlExecutor.SlowListener getSlowListener() {
        return this.slowListener;
    }

    public void setSlowListener(SqlExecutor.SlowListener slowListener) {
        this.slowListener = slowListener;
    }

    protected static class Result {
        final PreparedStatement statement;
        final ResultSet resultSet;

        Result(PreparedStatement statement, ResultSet resultSet) {
            this.statement = statement;
            this.resultSet = resultSet;
        }

        void close() {
            DefaultSqlExecutor.closeQuietly(this.resultSet);
            DefaultSqlExecutor.closeQuietly(this.statement);
        }
    }
}

