/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.FieldConvertor;
import com.ejlchina.searcher.FieldMeta;
import java.math.BigDecimal;
import java.math.BigInteger;

public class StrNumFieldConvertor
implements FieldConvertor.BFieldConvertor {
    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType) {
        if (valueType == String.class) {
            Class<?> targetType = meta.getType();
            return targetType == Integer.TYPE || targetType == Integer.class || targetType == Long.TYPE || targetType == Long.class || targetType == Float.TYPE || targetType == Float.class || targetType == Double.TYPE || targetType == Double.class || targetType == Short.TYPE || targetType == Short.class || targetType == Byte.TYPE || targetType == Byte.class || targetType == BigDecimal.class || targetType == BigInteger.class;
        }
        return false;
    }

    @Override
    public Object convert(FieldMeta meta, Object value) {
        String number = (String)value;
        Class<?> targetType = meta.getType();
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return Integer.parseInt(number);
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            return Long.parseLong(number);
        }
        if (targetType == Float.TYPE || targetType == Float.class) {
            return Float.valueOf(Float.parseFloat(number));
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            return Double.parseDouble(number);
        }
        if (targetType == Short.TYPE || targetType == Short.class) {
            return Short.parseShort(number);
        }
        if (targetType == Byte.TYPE || targetType == Byte.class) {
            return Byte.parseByte(number);
        }
        if (targetType == BigDecimal.class) {
            return new BigDecimal(number);
        }
        if (targetType == BigInteger.class) {
            return new BigInteger(number);
        }
        throw new IllegalStateException("Unsupported targetType: " + targetType);
    }
}

