/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.util;

import com.ejlchina.searcher.FieldOp;
import com.ejlchina.searcher.param.FieldParam;
import com.ejlchina.searcher.util.MapBuilder;
import com.ejlchina.searcher.util.StringUtils;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class Builder<B extends Builder<B>> {
    private final Map<FieldFn<?, ?>, String> cache = new ConcurrentHashMap();
    protected final Map<String, Object> map;
    protected String group;
    private FieldParam fieldParam = null;

    public Builder(Map<String, Object> map) {
        this(map, null);
    }

    public Builder(Map<String, Object> map, String group) {
        this.map = map;
        this.group = group;
    }

    public <T> B field(FieldFn<T, ?> fieldFn, Collection<?> values) {
        return this.field(fieldFn, values.toArray());
    }

    public <T> B field(FieldFn<T, ?> fieldFn, Object ... values) {
        return this.field(this.toFieldName(fieldFn), values);
    }

    public <T> B field(String fieldName, Collection<?> values) {
        return this.field(fieldName, values.toArray());
    }

    public B field(String fieldName, Object ... values) {
        if (fieldName != null) {
            ArrayList<FieldParam.Value> pValues = new ArrayList<FieldParam.Value>();
            for (int index = 0; index < values.length; ++index) {
                pValues.add(new FieldParam.Value(values[index], index));
            }
            String field = fieldName.trim();
            this.fieldParam = new FieldParam(field, pValues);
            if (this.group != null) {
                this.map.put(this.group + MapBuilder.FIELD_PARAM + field, this.fieldParam);
            } else {
                this.map.put(MapBuilder.FIELD_PARAM + field, this.fieldParam);
            }
        }
        return (B)this;
    }

    public B op(String operator) {
        return this.fieldOp(operator);
    }

    public B op(Class<? extends FieldOp> operator) {
        return this.fieldOp(operator);
    }

    public B op(FieldOp operator) {
        return this.fieldOp(operator);
    }

    private B fieldOp(Object operator) {
        if (this.fieldParam == null) {
            throw new IllegalStateException("the method [ op(...) ] must go after [ field(...) ] method");
        }
        this.fieldParam.setOperator(operator);
        return (B)this;
    }

    public B ic() {
        return this.ic(true);
    }

    public B ic(boolean ignoreCase) {
        if (this.fieldParam == null) {
            throw new IllegalStateException("the method [ ic(...) ] must go after [ field(...) ] method");
        }
        this.fieldParam.setIgnoreCase(ignoreCase);
        return (B)this;
    }

    protected String toFieldName(FieldFn<?, ?> fieldFn) {
        String fieldName = this.cache.get(fieldFn);
        if (fieldName != null) {
            return fieldName;
        }
        try {
            String methodName;
            boolean isInaccessible;
            Method wrMethod = fieldFn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            boolean bl = isInaccessible = !wrMethod.isAccessible();
            if (isInaccessible) {
                wrMethod.setAccessible(true);
            }
            SerializedLambda sLambda = (SerializedLambda)wrMethod.invoke(fieldFn, new Object[0]);
            if (isInaccessible) {
                wrMethod.setAccessible(false);
            }
            if ((methodName = sLambda.getImplMethodName()).startsWith("get") && methodName.length() > 3) {
                fieldName = StringUtils.firstCharToLoweCase(methodName.substring(3));
            }
            if (methodName.startsWith("is") && methodName.length() > 2) {
                fieldName = StringUtils.firstCharToLoweCase(methodName.substring(2));
            }
            if (fieldName != null) {
                this.cache.put(fieldFn, fieldName);
                return fieldName;
            }
            throw new IllegalStateException("can not convert method [" + methodName + "] to field name");
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("\u65e0\u6cd5\u53cd\u5c04\u51fa\u5b57\u6bb5\u540d", e);
        }
    }

    protected <T> List<T> obtainList(String key) {
        Object value = this.map.get(key);
        ArrayList list = null;
        if (value instanceof List) {
            ArrayList l;
            list = l = (ArrayList)value;
        }
        if (list == null) {
            list = new ArrayList();
            this.map.put(key, list);
        }
        return list;
    }

    @FunctionalInterface
    public static interface FieldFn<T, R>
    extends Function<T, R>,
    Serializable {
    }
}

