/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.util;

import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchParam;
import com.ejlchina.searcher.param.FieldParam;
import com.ejlchina.searcher.param.OrderBy;
import com.ejlchina.searcher.param.Paging;
import com.ejlchina.searcher.util.Builder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MapBuilder
extends Builder<MapBuilder> {
    public static final String ORDER_BY = OrderBy.class.getName();
    public static final String PAGING = Paging.class.getName();
    public static final String FIELD_PARAM = FieldParam.class.getName();
    public static final String ONLY_SELECT = SearchParam.class.getName() + ".ONLY_SELECT";
    public static final String SELECT_EXCLUDE = SearchParam.class.getName() + ".SELECT_EXCLUDE";
    public static final String GROUP_EXPR = SearchParam.class.getName() + ".GROUP_EXPR";

    public MapBuilder(Map<String, Object> map) {
        super(map);
    }

    public MapBuilder put(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    @SafeVarargs
    public final <T> MapBuilder onlySelect(Builder.FieldFn<T, ?> ... fieldFns) {
        return this.onlySelect(this.toFields(fieldFns));
    }

    public MapBuilder onlySelect(String ... fields) {
        return this.appendFields(this.obtainList(ONLY_SELECT), fields);
    }

    @SafeVarargs
    public final <T> MapBuilder selectExclude(Builder.FieldFn<T, ?> ... fieldFns) {
        return this.selectExclude(this.toFields(fieldFns));
    }

    public MapBuilder selectExclude(String ... fields) {
        return this.appendFields(this.obtainList(SELECT_EXCLUDE), fields);
    }

    @SafeVarargs
    private final <T> String[] toFields(Builder.FieldFn<T, ?> ... fieldFns) {
        String[] fields = new String[fieldFns.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this.toFieldName(fieldFns[i]);
        }
        return fields;
    }

    private MapBuilder appendFields(List<String> list, String ... fields) {
        if (fields.length == 1) {
            Collections.addAll(list, fields[0].split(","));
        } else {
            Collections.addAll(list, fields);
        }
        return this;
    }

    public MapBuilder group(String group) {
        this.group = group;
        return this;
    }

    public MapBuilder groupExpr(String gExpr) {
        this.map.put(GROUP_EXPR, gExpr);
        return this;
    }

    public <T> MapBuilder orderBy(Builder.FieldFn<T, ?> fieldFn, String order) {
        return this.orderBy(this.toFieldName(fieldFn), order);
    }

    public MapBuilder orderBy(String fieldName, String order) {
        if (fieldName != null) {
            List orderBys = this.obtainList(ORDER_BY);
            Optional<OrderBy> orderByOpt = orderBys.stream().filter(orderBy -> fieldName.equals(orderBy.getSort())).findAny();
            if (orderByOpt.isPresent()) {
                throw new SearchException("\u91cd\u590d\u6dfb\u52a0\u6392\u5e8f\u5b57\u6bb5\uff1a" + fieldName + " " + order);
            }
            orderBys.add(new OrderBy(fieldName, order));
        }
        return this;
    }

    public <T> MapBuilder orderBy(Builder.FieldFn<T, ?> fieldFn) {
        return this.orderBy(this.toFieldName(fieldFn), "asc");
    }

    public MapBuilder orderBy(String fieldName) {
        return this.orderBy(fieldName, "asc");
    }

    public MapBuilder asc() {
        List orderBys = this.obtainList(ORDER_BY);
        if (orderBys.isEmpty()) {
            throw new IllegalStateException("asc() must call after orderBy(..) method.");
        }
        int index = orderBys.size() - 1;
        OrderBy last = (OrderBy)orderBys.get(index);
        if (last.isDesc()) {
            orderBys.set(index, last.asc());
        }
        return this;
    }

    public MapBuilder desc() {
        List orderBys = this.obtainList(ORDER_BY);
        if (orderBys.isEmpty()) {
            throw new IllegalStateException("desc() must call after orderBy(..) method.");
        }
        int index = orderBys.size() - 1;
        OrderBy last = (OrderBy)orderBys.get(index);
        if (last.isAsc()) {
            orderBys.set(index, last.desc());
        }
        return this;
    }

    public MapBuilder page(long page, int size) {
        this.map.put(PAGING, new Page(size, page));
        return this;
    }

    public MapBuilder limit(long offset, int size) {
        this.map.put(PAGING, new Limit(size, offset));
        return this;
    }

    public Map<String, Object> build() {
        return this.map;
    }

    public static class Limit {
        private final int size;
        private final long offset;

        public Limit(int size, long offset) {
            this.size = size;
            this.offset = offset;
        }

        public int getSize() {
            return this.size;
        }

        public long getOffset() {
            return this.offset;
        }
    }

    public static class Page {
        private final int size;
        private final long page;

        public Page(int size, long page) {
            this.size = size;
            this.page = page;
        }

        public int getSize() {
            return this.size;
        }

        public long getPage() {
            return this.page;
        }
    }
}

