/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher;

import com.ejlchina.searcher.group.Group;
import com.ejlchina.searcher.param.FetchType;
import com.ejlchina.searcher.param.FieldParam;
import com.ejlchina.searcher.param.OrderBy;
import com.ejlchina.searcher.param.Paging;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SearchParam {
    private final Map<String, Object> paraMap;
    private final FetchType fetchType;
    private final List<String> fetchFields;
    private final Group<List<FieldParam>> paramsGroup;
    private final List<OrderBy> orderBys = new ArrayList<OrderBy>();
    private final Paging paging;

    public SearchParam(Map<String, Object> paraMap, FetchType fetchType, List<String> fetchFields, Group<List<FieldParam>> paramsGroup, Paging paging) {
        this.paraMap = paraMap;
        this.fetchType = fetchType;
        this.fetchFields = fetchFields;
        this.paramsGroup = paramsGroup;
        this.paging = paging;
    }

    public Map<String, Object> getParaMap() {
        return this.paraMap;
    }

    public FetchType getFetchType() {
        return this.fetchType;
    }

    public List<String> getFetchFields() {
        return this.fetchFields;
    }

    public Group<List<FieldParam>> getParamsGroup() {
        return this.paramsGroup;
    }

    public Paging getPaging() {
        return this.paging;
    }

    public int getPageSize() {
        if (this.paging != null) {
            return this.paging.getSize();
        }
        return 0;
    }

    public void addOrderBy(OrderBy orderBy) {
        this.orderBys.add(orderBy);
    }

    public List<OrderBy> getOrderBys() {
        return this.orderBys;
    }
}

