/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.convertor;

import com.ejlchina.searcher.FieldConvertor;
import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.util.ObjKey2;
import com.ejlchina.searcher.util.StringUtils;
import java.sql.Date;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class DateFormatFieldConvertor
implements FieldConvertor.MFieldConvertor {
    public static final Pattern DATE_PATTERN = Pattern.compile("[yMd]+");
    public static final Pattern TIME_PATTERN = Pattern.compile("[HhmsS]+");
    private final Map<String, Formatter> formatMap = new ConcurrentHashMap<String, Formatter>();
    private ZoneId zoneId = ZoneId.systemDefault();
    private final Map<ObjKey2, Formatter> cache = new ConcurrentHashMap<ObjKey2, Formatter>();
    private final Formatter NULL_FORMATTER = new Formatter(null);
    private final Map<Class<?>, List<String>> typeNameMap = new ConcurrentHashMap();

    public void setFormat(String scope, String format) {
        if (StringUtils.isBlank(format) || "NULL".equalsIgnoreCase(format.trim())) {
            this.formatMap.put(scope, new Formatter(null));
            return;
        }
        try {
            this.formatMap.put(scope, new Formatter(format));
        }
        catch (IllegalArgumentException e) {
            throw new SearchException("Invalid DATE/TIME format: [scope: " + scope + ", format: " + format + "]", e);
        }
    }

    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType) {
        Formatter f;
        ObjKey2 key = new ObjKey2(meta, valueType);
        Formatter formatter = this.cache.get(key);
        if (formatter == this.NULL_FORMATTER) {
            return false;
        }
        if (formatter != null) {
            return formatter.pattern != null;
        }
        if ((java.util.Date.class.isAssignableFrom(valueType) || Temporal.class.isAssignableFrom(valueType)) && (f = this.findFormatter(meta, valueType)) != null) {
            this.cache.put(key, f);
            return f.pattern != null;
        }
        this.cache.put(key, this.NULL_FORMATTER);
        return false;
    }

    @Override
    public Object convert(FieldMeta meta, Object value) {
        ObjKey2 key = new ObjKey2(meta, value.getClass());
        Formatter formatter = this.cache.get(key);
        if (formatter != null) {
            return formatter.format(value);
        }
        throw new IllegalStateException("The supports(FieldMeta, Class<?>) method must be called first and return true before convert(FieldMeta, Object) method can be called");
    }

    private Formatter findFormatter(FieldMeta meta, Class<?> type) {
        Class<?> clazz = meta.getBeanMeta().getBeanClass();
        String pathName = clazz.getName();
        Formatter formatter = this.formatMap.get(pathName + "." + meta.getName());
        if (formatter != null && formatter.supports(type)) {
            return formatter;
        }
        List<String> typeNames = this.getTypeNames(type);
        while (true) {
            for (String typeName : typeNames) {
                formatter = this.formatMap.get(pathName + ":" + typeName);
                if (formatter == null || !formatter.supports(type)) continue;
                return formatter;
            }
            formatter = this.formatMap.get(pathName);
            if (formatter != null && formatter.supports(type)) {
                return formatter;
            }
            int index = pathName.lastIndexOf(46);
            if (index <= -1) break;
            pathName = pathName.substring(0, index);
        }
        return null;
    }

    private List<String> getTypeNames(Class<?> type) {
        List names = this.typeNameMap.computeIfAbsent(type, k -> new ArrayList(3));
        if (names.isEmpty()) {
            while (type != null && type != Object.class) {
                names.add(type.getSimpleName());
                type = type.getSuperclass();
            }
        }
        return names;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = Objects.requireNonNull(zoneId);
    }

    public class Formatter {
        private final String pattern;
        private final DateTimeFormatter formatter;

        public Formatter(String pattern) {
            this.formatter = pattern != null ? DateTimeFormatter.ofPattern(pattern) : null;
            this.pattern = pattern;
        }

        public Object format(Object value) {
            if (this.formatter != null) {
                if (value instanceof Date) {
                    LocalDate localDate = ((Date)value).toLocalDate();
                    return this.formatter.format(localDate);
                }
                if (value instanceof Time) {
                    LocalTime localTime = ((Time)value).toLocalTime();
                    return this.formatter.format(localTime);
                }
                if (value instanceof java.util.Date) {
                    Instant instant = ((java.util.Date)value).toInstant();
                    LocalDateTime dateTime = LocalDateTime.ofInstant(instant, DateFormatFieldConvertor.this.zoneId);
                    return this.formatter.format(dateTime);
                }
                if (value instanceof Instant) {
                    LocalDateTime dateTime = LocalDateTime.ofInstant((Instant)value, DateFormatFieldConvertor.this.zoneId);
                    return this.formatter.format(dateTime);
                }
                if (value instanceof Temporal) {
                    return this.formatter.format((Temporal)value);
                }
            }
            return value;
        }

        public boolean supports(Class<?> dateType) {
            return this.pattern == null || dateType != LocalTime.class && dateType != Time.class && dateType != LocalDate.class && dateType != Date.class || (dateType == LocalTime.class || dateType == Time.class) && !DATE_PATTERN.matcher(this.pattern).find() || (dateType == LocalDate.class || dateType == Date.class) && !TIME_PATTERN.matcher(this.pattern).find();
        }
    }
}

