/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.convertor;

import com.ejlchina.searcher.FieldConvertor;
import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.SearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumFieldConvertor
implements FieldConvertor.BFieldConvertor {
    static final Logger log = LoggerFactory.getLogger(EnumFieldConvertor.class);
    private boolean failOnError = true;
    private boolean ignoreCase = false;

    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType) {
        if (valueType == String.class || valueType == Integer.TYPE || valueType == Integer.class) {
            return Enum.class.isAssignableFrom(meta.getType());
        }
        return false;
    }

    @Override
    public Object convert(FieldMeta meta, Object value) {
        if (value instanceof String) {
            return this.doConvert(meta.getType(), (String)value);
        }
        if (value instanceof Integer) {
            return this.doConvert(meta.getType(), (Integer)value);
        }
        throw new IllegalStateException("The supports(FieldMeta, Class<?>) method must be called first and return true before convert(FieldMeta, Object) method can be called");
    }

    protected Object doConvert(Class<?> targetType, String name) {
        block6: {
            if (this.ignoreCase) {
                for (Object v : targetType.getEnumConstants()) {
                    if (!((Enum)v).name().equalsIgnoreCase(name)) continue;
                    return v;
                }
                if (this.failOnError) {
                    throw new SearchException("Can not convert [" + name + "] to " + targetType);
                }
            } else {
                try {
                    return Enum.valueOf(targetType, name);
                }
                catch (IllegalArgumentException e) {
                    if (!this.failOnError) break block6;
                    throw e;
                }
            }
        }
        log.warn("Can not convert [{}] to {}", (Object)name, targetType);
        return null;
    }

    protected Object doConvert(Class<?> targetType, int ordinal) {
        for (Object v : targetType.getEnumConstants()) {
            if (((Enum)v).ordinal() != ordinal) continue;
            return v;
        }
        if (this.failOnError) {
            throw new IllegalArgumentException("Can not convert [" + ordinal + "] to " + targetType);
        }
        log.warn("Can not convert [{}] to {}", (Object)ordinal, targetType);
        return null;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }
}

