/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.BeanReflector;
import com.ejlchina.searcher.BeanSearcher;
import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.ResultFilter;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchResult;
import com.ejlchina.searcher.SearchSql;
import com.ejlchina.searcher.SqlExecutor;
import com.ejlchina.searcher.SqlResult;
import com.ejlchina.searcher.bean.BeanAware;
import com.ejlchina.searcher.bean.ParamAware;
import com.ejlchina.searcher.implement.AbstractSearcher;
import com.ejlchina.searcher.implement.DefaultBeanReflector;
import com.ejlchina.searcher.param.FetchType;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultBeanSearcher
extends AbstractSearcher
implements BeanSearcher {
    private BeanReflector beanReflector = new DefaultBeanReflector();

    public DefaultBeanSearcher() {
    }

    public DefaultBeanSearcher(SqlExecutor sqlExecutor) {
        super(sqlExecutor);
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(0));
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap, String[] summaryFields) {
        return this.search(beanClass, paraMap, new FetchType(0, summaryFields));
    }

    @Override
    public <T> T searchFirst(Class<T> beanClass, Map<String, Object> paraMap) {
        FetchType fetchType = new FetchType(1);
        List<T> list = this.search(beanClass, paraMap, fetchType).getDataList();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> List<T> searchList(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(2)).getDataList();
    }

    @Override
    public <T> List<T> searchAll(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(3)).getDataList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap, FetchType fetchType) {
        try (SqlResult<T> sqlResult = this.doSearch(beanClass, paraMap, fetchType);){
            SearchSql<T> searchSql = sqlResult.getSearchSql();
            Number totalCount = 0L;
            Number[] summaries = SearchResult.EMPTY_SUMMARIES;
            if (searchSql.isShouldQueryCluster()) {
                totalCount = this.getCountFromSqlResult(sqlResult);
                summaries = this.getSummaryFromSqlResult(sqlResult);
            }
            SearchResult result = new SearchResult(totalCount, sqlResult.getPageSize(), summaries);
            BeanMeta<T> beanMeta = searchSql.getBeanMeta();
            SqlResult.ResultSet listResult = sqlResult.getListResult();
            if (listResult != null) {
                List<FieldMeta> fieldMetas = searchSql.getFetchFields().stream().map(beanMeta::requireFieldMeta).collect(Collectors.toList());
                this.collectList(result.getDataList(), listResult, beanMeta, fieldMetas, paraMap);
            }
            SearchResult searchResult = this.doFilter(result, beanMeta, paraMap, fetchType);
            return searchResult;
        }
        catch (SQLException e) {
            throw new SearchException("A exception occurred when collecting sql result!", e);
        }
    }

    protected <T> void collectList(List<T> dataList, SqlResult.ResultSet listResult, BeanMeta<T> beanMeta, List<FieldMeta> fieldMetas, Map<String, Object> paraMap) throws SQLException {
        while (listResult.next()) {
            T bean = this.beanReflector.reflect(beanMeta, fieldMetas, dbAlias -> {
                try {
                    return listResult.get((String)dbAlias);
                }
                catch (SQLException e) {
                    throw new SearchException("A exception occurred when collecting sql result!", e);
                }
            });
            if (bean instanceof BeanAware) {
                ((BeanAware)bean).afterAssembly();
            }
            if (bean instanceof ParamAware) {
                ((ParamAware)bean).afterAssembly(paraMap);
            }
            dataList.add(bean);
        }
    }

    protected <T> SearchResult<T> doFilter(SearchResult<T> result, BeanMeta<T> beanMeta, Map<String, Object> paraMap, FetchType fetchType) {
        for (ResultFilter filter : this.getResultFilters()) {
            result = filter.doBeanFilter(result, beanMeta, paraMap, fetchType);
        }
        return result;
    }

    public BeanReflector getBeanReflector() {
        return this.beanReflector;
    }

    public void setBeanReflector(BeanReflector beanReflector) {
        this.beanReflector = Objects.requireNonNull(beanReflector);
    }
}

