/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.FieldOp;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchParam;
import com.ejlchina.searcher.SearchSql;
import com.ejlchina.searcher.SqlResolver;
import com.ejlchina.searcher.SqlSnippet;
import com.ejlchina.searcher.SqlWrapper;
import com.ejlchina.searcher.dialect.Dialect;
import com.ejlchina.searcher.dialect.DialectWrapper;
import com.ejlchina.searcher.group.Group;
import com.ejlchina.searcher.param.FetchType;
import com.ejlchina.searcher.param.FieldParam;
import com.ejlchina.searcher.param.OrderBy;
import com.ejlchina.searcher.param.Paging;
import com.ejlchina.searcher.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DefaultSqlResolver
extends DialectWrapper
implements SqlResolver {
    private static final Group<List<FieldParam>> EMPTY_GROUP = new Group(Collections.emptyList());

    public DefaultSqlResolver() {
    }

    public DefaultSqlResolver(Dialect dialect) {
        super(dialect);
    }

    @Override
    public <T> SearchSql<T> resolve(BeanMeta<T> beanMeta, SearchParam searchParam) {
        Paging paging;
        String[] summaryFields;
        List<String> fetchFields = searchParam.getFetchFields();
        FetchType fetchType = searchParam.getFetchType();
        SearchSql<T> searchSql = new SearchSql<T>(beanMeta, fetchFields);
        searchSql.setShouldQueryCluster(fetchType.shouldQueryCluster());
        searchSql.setShouldQueryList(fetchType.shouldQueryList());
        if (fetchType.shouldQueryTotal()) {
            searchSql.setCountAlias(this.getCountAlias(beanMeta));
        }
        for (String summaryField : summaryFields = fetchType.getSummaryFields()) {
            FieldMeta fieldMeta = beanMeta.getFieldMeta(summaryField);
            if (fieldMeta == null) {
                throw new SearchException("No such field [" + summaryField + "] on " + beanMeta.getBeanClass() + " for summary.");
            }
            searchSql.addSummaryAlias(this.getSummaryAlias(fieldMeta));
        }
        Map<String, Object> paraMap = searchParam.getParaMap();
        SqlWrapper<Object> fieldSelectSqlWrapper = this.buildFieldSelectSql(beanMeta, fetchFields, paraMap);
        SqlWrapper<Object> fromWhereSqlWrapper = this.buildFromWhereSql(beanMeta, searchParam);
        String fieldSelectSql = fieldSelectSqlWrapper.getSql();
        String fromWhereSql = fromWhereSqlWrapper.getSql();
        if (fetchType.shouldQueryTotal() || summaryFields.length > 0) {
            List<String> summaryAliases = searchSql.getSummaryAliases();
            String countAlias = searchSql.getCountAlias();
            SqlWrapper<Object> clusterSelectSql = this.buildClusterSelectSql(beanMeta, summaryFields, summaryAliases, countAlias, paraMap);
            String clusterSql = this.buildClusterSql(beanMeta, clusterSelectSql.getSql(), fieldSelectSql, fromWhereSql);
            searchSql.setClusterSqlString(clusterSql);
            searchSql.addClusterSqlParams(clusterSelectSql.getParas());
            if (beanMeta.isDistinctOrGroupBy()) {
                searchSql.addClusterSqlParams(fieldSelectSqlWrapper.getParas());
            }
            searchSql.addClusterSqlParams(fromWhereSqlWrapper.getParas());
        }
        if (fetchType.shouldQueryList() && ((paging = searchParam.getPaging()) == null || paging.getSize() > 0)) {
            List<OrderBy> orderBys = searchParam.getOrderBys();
            SqlWrapper<Object> listSql = this.buildListSql(beanMeta, fieldSelectSql, fromWhereSql, orderBys, paging, fetchFields, paraMap);
            searchSql.setListSqlString(listSql.getSql());
            searchSql.addListSqlParams(fieldSelectSqlWrapper.getParas());
            searchSql.addListSqlParams(fromWhereSqlWrapper.getParas());
            searchSql.addListSqlParams(listSql.getParas());
        }
        return searchSql;
    }

    protected <T> SqlWrapper<Object> buildFieldSelectSql(BeanMeta<T> beanMeta, List<String> fetchFields, Map<String, Object> paraMap) {
        SqlWrapper<Object> sqlWrapper = new SqlWrapper<Object>();
        StringBuilder builder = new StringBuilder("select ");
        if (beanMeta.isDistinct()) {
            builder.append("distinct ");
        }
        int fieldCount = fetchFields.size();
        for (int i = 0; i < fieldCount; ++i) {
            String field = fetchFields.get(i);
            FieldMeta meta = beanMeta.requireFieldMeta(field);
            SqlWrapper<Object> dbFieldSql = this.resolveDbFieldSql(meta.getFieldSql(), paraMap);
            builder.append(dbFieldSql.getSql()).append(" ").append(meta.getDbAlias());
            if (i < fieldCount - 1) {
                builder.append(", ");
            }
            sqlWrapper.addParas(dbFieldSql.getParas());
        }
        sqlWrapper.setSql(builder.toString());
        return sqlWrapper;
    }

    protected <T> SqlWrapper<Object> buildClusterSelectSql(BeanMeta<T> beanMeta, String[] summaryFields, List<String> summaryAliases, String countAlias, Map<String, Object> paraMap) {
        StringBuilder builder = new StringBuilder("select ");
        if (countAlias != null) {
            builder.append("count(*) ").append(countAlias);
            if (summaryFields.length > 0) {
                builder.append(", ");
            }
        }
        SqlWrapper<Object> sqlWrapper = new SqlWrapper<Object>();
        boolean distinctOrGroupBy = beanMeta.isDistinctOrGroupBy();
        for (int i = 0; i < summaryFields.length; ++i) {
            FieldMeta fieldMeta = beanMeta.requireFieldMeta(summaryFields[i]);
            builder.append("sum(");
            if (distinctOrGroupBy) {
                builder.append(fieldMeta.getDbAlias());
            } else {
                SqlWrapper<Object> fieldSql = this.resolveDbFieldSql(fieldMeta.getFieldSql(), paraMap);
                builder.append(fieldSql.getSql());
                sqlWrapper.addParas(fieldSql.getParas());
            }
            builder.append(") ").append(summaryAliases.get(i));
            if (i >= summaryFields.length - 1) continue;
            builder.append(", ");
        }
        sqlWrapper.setSql(builder.toString());
        return sqlWrapper;
    }

    protected SqlWrapper<Object> buildFromWhereSql(BeanMeta<?> beanMeta, SearchParam searchParam) {
        SqlWrapper<Object> groupBy;
        Group<List<FieldParam>> paramsGroup = searchParam.getParamsGroup();
        List<String> fetchFields = searchParam.getFetchFields();
        Map<String, Object> paraMap = searchParam.getParaMap();
        SqlWrapper<Object> sqlWrapper = new SqlWrapper<Object>();
        SqlWrapper<Object> tableSql = this.resolveTableSql(beanMeta.getTableSnippet(), paraMap);
        sqlWrapper.addParas(tableSql.getParas());
        StringBuilder builder = new StringBuilder(" from ").append(tableSql.getSql());
        String where = beanMeta.getWhere();
        if (StringUtils.isNotBlank(where)) {
            where = this.buildSqlSnippet(where, beanMeta.getWhereSqlParas(), paraMap, sqlWrapper.getParas());
        }
        GroupPair groupPair = this.resolveGroupPair(beanMeta, paramsGroup, (groupBy = this.resolveGroupBy(beanMeta, paraMap)) == null);
        Group<List<FieldParam>> whereGroup = groupPair.getWhereGroup();
        boolean hasWhere = StringUtils.isNotBlank(where);
        boolean hasWhereParams = whereGroup.judgeAny(l -> l.size() > 0);
        if (hasWhere || hasWhereParams) {
            builder.append(" where ");
            if (hasWhere) {
                builder.append("(").append(where).append(")");
                if (hasWhereParams) {
                    builder.append(" and ");
                }
            }
            if (hasWhereParams) {
                this.useGroup(whereGroup, beanMeta, fetchFields, paraMap, builder, sqlWrapper.getParas(), false);
            }
        }
        if (groupBy != null) {
            builder.append(" group by ").append(groupBy.getSql());
            sqlWrapper.addParas(groupBy.getParas());
            String having = beanMeta.getHaving();
            if (StringUtils.isNotBlank(having)) {
                having = this.buildSqlSnippet(having, beanMeta.getHavingSqlParas(), paraMap, sqlWrapper.getParas());
            }
            Group<List<FieldParam>> havingGroup = groupPair.getHavingGroup();
            boolean hasHaving = StringUtils.isNotBlank(having);
            boolean hasHavingParams = havingGroup.judgeAny(l -> l.size() > 0);
            if (hasHaving || hasHavingParams) {
                builder.append(" having ");
                if (hasHaving) {
                    builder.append("(").append(having).append(")");
                    if (hasHavingParams) {
                        builder.append(" and ");
                    }
                }
                if (hasHavingParams) {
                    this.useGroup(havingGroup, beanMeta, fetchFields, paraMap, builder, sqlWrapper.getParas(), true);
                }
            }
        }
        sqlWrapper.setSql(builder.toString());
        return sqlWrapper;
    }

    protected void useGroup(Group<List<FieldParam>> group, BeanMeta<?> beanMeta, List<String> fetchFields, Map<String, Object> paraMap, StringBuilder sqlBuilder, List<Object> paraReceiver, boolean isHaving) {
        group.forEach(event -> {
            if (event.isGroupStart()) {
                sqlBuilder.append("(");
                return;
            }
            if (event.isGroupEnd()) {
                sqlBuilder.append(")");
                return;
            }
            if (event.isGroupAnd()) {
                sqlBuilder.append(" and ");
                return;
            }
            if (event.isGroupOr()) {
                sqlBuilder.append(" or ");
                return;
            }
            List params = (List)event.getValue();
            for (int i = 0; i < params.size(); ++i) {
                if (i == 0) {
                    sqlBuilder.append("(");
                } else {
                    sqlBuilder.append(" and (");
                }
                FieldParam param = (FieldParam)params.get(i);
                FieldOp.OpPara opPara = new FieldOp.OpPara(name -> {
                    String field = name != null ? name : param.getName();
                    FieldMeta meta = beanMeta.requireFieldMeta(field);
                    SqlSnippet sql = meta.getFieldSql();
                    if (isHaving && fetchFields.contains(field)) {
                        sql = new SqlSnippet(meta.getDbAlias());
                    }
                    return this.resolveDbFieldSql(sql, paraMap);
                }, param.isIgnoreCase(), param.getValues());
                FieldOp operator = (FieldOp)param.getOperator();
                paraReceiver.addAll(operator.operate(sqlBuilder, opPara));
                sqlBuilder.append(")");
            }
        });
    }

    protected SqlWrapper<Object> resolveGroupBy(BeanMeta<?> beanMeta, Map<String, Object> paraMap) {
        String groupBy = beanMeta.getGroupBy();
        if (StringUtils.isNotBlank(groupBy)) {
            SqlWrapper<Object> sqlWrapper = new SqlWrapper<Object>();
            if (StringUtils.isNotBlank(groupBy = this.buildSqlSnippet(groupBy, beanMeta.getGroupBySqlParas(), paraMap, sqlWrapper.getParas()))) {
                sqlWrapper.setSql(groupBy);
                return sqlWrapper;
            }
        }
        return null;
    }

    private GroupPair resolveGroupPair(BeanMeta<?> beanMeta, Group<List<FieldParam>> paramsGroup, boolean nonGroupBy) {
        if (nonGroupBy) {
            return new GroupPair(paramsGroup, EMPTY_GROUP);
        }
        String groupBy = beanMeta.getGroupBy();
        if (paramsGroup.isRaw()) {
            ArrayList<FieldParam> where = new ArrayList<FieldParam>();
            ArrayList<FieldParam> having = new ArrayList<FieldParam>();
            for (FieldParam param : paramsGroup.getValue()) {
                if (StringUtils.sqlContains(groupBy, beanMeta.getFieldSql(param.getName()))) {
                    where.add(param);
                    continue;
                }
                having.add(param);
            }
            return new GroupPair(new Group<List<FieldParam>>(where), new Group<List<FieldParam>>(having));
        }
        return new GroupPair(EMPTY_GROUP, paramsGroup);
    }

    protected String buildSqlSnippet(String sqlSnippet, List<SqlSnippet.SqlPara> sqlParas, Map<String, Object> paraMap, List<Object> paraReceiver) {
        for (SqlSnippet.SqlPara sqlPara : sqlParas) {
            Object para = paraMap.get(sqlPara.getName());
            if (sqlPara.isJdbcPara()) {
                paraReceiver.add(para);
                continue;
            }
            String strParam = para != null ? para.toString() : "";
            sqlSnippet = sqlSnippet.replace(sqlPara.getSqlName(), strParam);
        }
        return sqlSnippet;
    }

    protected <T> String buildClusterSql(BeanMeta<T> beanMeta, String clusterSelectSql, String fieldSelectSql, String fromWhereSql) {
        if (beanMeta.isDistinctOrGroupBy()) {
            String tableAlias = this.getTableAlias(beanMeta);
            return clusterSelectSql + " from (" + fieldSelectSql + fromWhereSql + ") " + tableAlias;
        }
        return clusterSelectSql + fromWhereSql;
    }

    protected <T> SqlWrapper<Object> buildListSql(BeanMeta<T> beanMeta, String fieldSelectSql, String fromWhereSql, List<OrderBy> orderBys, Paging paging, List<String> fetchFields, Map<String, Object> paraMap) {
        SqlSnippet orderBySnippet = beanMeta.getOrderBySnippet();
        boolean defaultOrderBy = StringUtils.isNotBlank(orderBySnippet.getSql());
        StringBuilder builder = new StringBuilder(fromWhereSql);
        int count = orderBys.size();
        if (count > 0 || defaultOrderBy) {
            builder.append(" order by ");
        }
        for (int index = 0; index < count; ++index) {
            OrderBy orderBy = orderBys.get(index);
            FieldMeta meta = beanMeta.requireFieldMeta(orderBy.getSort());
            if (fetchFields.contains(meta.getName())) {
                builder.append(meta.getDbAlias());
            } else {
                builder.append(meta.getFieldSql().getSql());
            }
            String order = orderBy.getOrder();
            if (StringUtils.isNotBlank(order)) {
                builder.append(' ').append(order);
            }
            if (index >= count - 1) continue;
            builder.append(", ");
        }
        if (count == 0 && defaultOrderBy) {
            SqlWrapper<Object> dbFieldSql = this.resolveDbFieldSql(orderBySnippet, paraMap);
            builder.append(dbFieldSql.getSql());
            SqlWrapper<Object> sqlWrapper = this.forPaginate(fieldSelectSql, builder.toString(), paging);
            SqlWrapper<Object> listSql = new SqlWrapper<Object>(sqlWrapper.getSql());
            listSql.addParas(dbFieldSql.getParas());
            listSql.addParas(sqlWrapper.getParas());
            return listSql;
        }
        return this.forPaginate(fieldSelectSql, builder.toString(), paging);
    }

    protected SqlWrapper<Object> resolveTableSql(SqlSnippet tableSnippet, Map<String, Object> paraMap) {
        SqlWrapper<Object> sqlWrapper = new SqlWrapper<Object>();
        String tables = tableSnippet.getSql();
        List<SqlSnippet.SqlPara> params = tableSnippet.getParas();
        tables = this.buildSqlSnippet(tables, params, paraMap, sqlWrapper.getParas());
        sqlWrapper.setSql(tables);
        return sqlWrapper;
    }

    protected SqlWrapper<Object> resolveDbFieldSql(SqlSnippet dbFieldSnippet, Map<String, Object> paraMap) {
        String dbField = dbFieldSnippet.getSql();
        List<SqlSnippet.SqlPara> params = dbFieldSnippet.getParas();
        SqlWrapper<Object> sqlWrapper = new SqlWrapper<Object>();
        dbField = this.buildSqlSnippet(dbField, params, paraMap, sqlWrapper.getParas());
        sqlWrapper.setSql(dbField);
        return sqlWrapper;
    }

    protected <T> String getCountAlias(BeanMeta<T> beanMeta) {
        return "s_count";
    }

    protected String getSummaryAlias(FieldMeta fieldMeta) {
        return fieldMeta.getDbAlias() + "_sum_";
    }

    protected <T> String getTableAlias(BeanMeta<T> beanMeta) {
        return "t_";
    }

    protected static class GroupPair {
        final Group<List<FieldParam>> whereGroup;
        final Group<List<FieldParam>> havingGroup;

        public GroupPair(Group<List<FieldParam>> whereGroup, Group<List<FieldParam>> havingGroup) {
            this.whereGroup = whereGroup;
            this.havingGroup = havingGroup;
        }

        public Group<List<FieldParam>> getWhereGroup() {
            return this.whereGroup;
        }

        public Group<List<FieldParam>> getHavingGroup() {
            return this.havingGroup;
        }
    }
}

