/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.param;

import com.ejlchina.searcher.FieldOp;
import com.ejlchina.searcher.util.StringUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FieldParam {
    private final String name;
    private Object operator;
    private final List<Value> values;
    private boolean ignoreCase;

    public FieldParam(String name, FieldOp operator) {
        this(name, operator, Collections.emptyList(), false);
    }

    public FieldParam(String name, List<Value> values) {
        this.name = name;
        this.values = values;
    }

    public FieldParam(String name, FieldOp operator, List<Value> values, boolean ignoreCase) {
        this.name = name;
        this.operator = operator;
        this.values = values;
        this.ignoreCase = ignoreCase;
    }

    public String getName() {
        return this.name;
    }

    public Object[] getValues() {
        this.values.sort(Comparator.comparingInt(v -> ((Value)v).index));
        Object[] objects = new Object[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            objects[i] = this.values.get(i).value;
        }
        return objects;
    }

    public List<Value> getValueList() {
        return this.values;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Object getOperator() {
        return this.operator;
    }

    public void setOperator(Object operator) {
        this.operator = operator;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public static class Value {
        private final Object value;
        private final int index;

        public Value(Object value, int index) {
            this.value = value;
            this.index = index;
        }

        public boolean isEmptyValue() {
            return this.value == null || this.value instanceof String && StringUtils.isBlank((String)this.value);
        }

        public Object getValue() {
            return this.value;
        }
    }
}

