/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.param;

import com.ejlchina.searcher.util.StringUtils;
import java.util.Set;

public class OrderBy {
    public static final String ORDER_ASC = "asc";
    public static final String ORDER_DESC = "desc";
    private final String sort;
    private final String order;

    public OrderBy(String sort, String order) {
        this.sort = sort;
        this.order = order;
    }

    public String getSort() {
        return this.sort;
    }

    public String getOrder() {
        return this.order;
    }

    public boolean isValid(Set<String> fieldSet) {
        return fieldSet.contains(this.sort) && (StringUtils.isBlank(this.order) || ORDER_ASC.equalsIgnoreCase(this.order) || ORDER_DESC.equalsIgnoreCase(this.order));
    }

    public boolean isAsc() {
        return ORDER_ASC.equalsIgnoreCase(this.order);
    }

    public boolean isDesc() {
        return ORDER_DESC.equalsIgnoreCase(this.order);
    }

    public OrderBy asc() {
        return new OrderBy(this.sort, ORDER_ASC);
    }

    public OrderBy desc() {
        return new OrderBy(this.sort, ORDER_DESC);
    }

    public String toString() {
        return "OrderBy{ sort='" + this.sort + "', order='" + this.order + "'}";
    }
}

