/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.idm.authnication.offlineClient;

import com.cntaiping.idm.authnication.offlineClient.Hex;
import com.cntaiping.idm.authnication.offlineClient.SM3;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CNTPCrypt {
    private static final int BYTE_LENGTH = 32;
    private static final int BLOCK_LENGTH = 64;
    private static final int BUFFER_LENGTH = 64;
    private byte[] xBuf = new byte[64];
    private int xBufOff;
    private byte[] V = (byte[])SM3.iv.clone();
    private int cntBlock = 0;

    private int doFinal(byte[] out, int outOff) {
        byte[] tmp = this.doFinal();
        System.arraycopy(tmp, 0, out, 0, tmp.length);
        return 32;
    }

    private void reset() {
        this.xBufOff = 0;
        this.cntBlock = 0;
        this.V = (byte[])SM3.iv.clone();
    }

    private void update(byte[] in, int inOff, int len) {
        int partLen = 64 - this.xBufOff;
        int inputLen = len;
        int dPos = inOff;
        if (partLen < inputLen) {
            System.arraycopy(in, dPos, this.xBuf, this.xBufOff, partLen);
            inputLen -= partLen;
            dPos += partLen;
            this.doUpdate();
            while (inputLen > 64) {
                System.arraycopy(in, dPos, this.xBuf, 0, 64);
                inputLen -= 64;
                dPos += 64;
                this.doUpdate();
            }
        }
        System.arraycopy(in, dPos, this.xBuf, this.xBufOff, inputLen);
        this.xBufOff += inputLen;
    }

    private void doUpdate() {
        byte[] B = new byte[64];
        int i = 0;
        while (i < 64) {
            System.arraycopy(this.xBuf, i, B, 0, B.length);
            this.doHash(B);
            i += 64;
        }
        this.xBufOff = 0;
    }

    private void doHash(byte[] B) {
        byte[] tmp = SM3.CF(this.V, B);
        System.arraycopy(tmp, 0, this.V, 0, this.V.length);
        ++this.cntBlock;
    }

    private byte[] doFinal() {
        byte[] B = new byte[64];
        byte[] buffer = new byte[this.xBufOff];
        System.arraycopy(this.xBuf, 0, buffer, 0, buffer.length);
        byte[] tmp = SM3.padding(buffer, this.cntBlock);
        int i = 0;
        while (i < tmp.length) {
            System.arraycopy(tmp, i, B, 0, B.length);
            this.doHash(B);
            i += 64;
        }
        return this.V;
    }

    private void update(byte in) {
        byte[] buffer = new byte[]{in};
        this.update(buffer, 0, 1);
    }

    public String getEncryptedContent(String pwdContent) throws Exception {
        if (pwdContent == null || "".equals(pwdContent)) {
            return "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        byte[] md = new byte[32];
        byte[] msg1 = pwdContent.getBytes();
        this.update(msg1, 0, msg1.length);
        this.doFinal(md, 0);
        String s = new String(Hex.encode(md));
        this.reset();
        System.out.println("new\u52a0\u5bc6" + s.toUpperCase());
        return s.toUpperCase();
    }

    public static boolean checkValid(String key1, String key2, String plaintext, String encryptedContent) {
        try {
            String contentOld = CNTPCrypt.getEncryptedContentOld(key1, key2, plaintext);
            CNTPCrypt sm3 = new CNTPCrypt();
            String contentNew = sm3.getEncryptedContent(String.valueOf(key2) + plaintext);
            return encryptedContent.equals(contentNew) || encryptedContent.contains(contentOld);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            System.out.println("\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301\u52a0\u5bc6\u7b97\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7edf\u4e00\u7528\u6237\u8ba4\u8bc1\u5e73\u53f0\u7ba1\u7406\u5458");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301\u52a0\u5bc6\u7b97\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7edf\u4e00\u7528\u6237\u8ba4\u8bc1\u5e73\u53f0\u7ba1\u7406\u5458");
            return false;
        }
    }

    private static String getEncryptedContentOld(String key1, String key2, String content) throws NoSuchAlgorithmException {
        if (key2.equals("")) {
            key2 = "EMPTY_KEY";
        }
        String result = String.valueOf(key2) + ":" + content;
        MessageDigest md5Md = null;
        Mac hmacMd = null;
        md5Md = MessageDigest.getInstance("MD5");
        hmacMd = Mac.getInstance("hmacSHA256");
        byte[] hashedBytes = md5Md.digest(result.getBytes());
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < hashedBytes.length) {
            sb.append(Integer.toString((hashedBytes[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        result = sb.toString();
        SecretKeySpec keySpec = new SecretKeySpec(key2.getBytes(), "hmacSHA256");
        try {
            hmacMd.init(keySpec);
        }
        catch (InvalidKeyException e) {
            return result;
        }
        hmacMd.update(result.getBytes());
        byte[] hmacHashed = hmacMd.doFinal();
        sb = new StringBuffer();
        int i2 = 0;
        while (i2 < hmacHashed.length) {
            sb.append(Integer.toString((hmacHashed[i2] & 0xFF) + 256, 16).substring(1));
            ++i2;
        }
        result = sb.toString();
        System.out.println("old\u52a0\u5bc6" + result);
        return result;
    }

    public static void main(String[] args) {
        CNTPCrypt sm3 = new CNTPCrypt();
        try {
            System.out.println(CNTPCrypt.checkValid("", "", "1qaz@WSX", "654AFE221300C6563F77471C103C03BA1C2343974C108A1F20FB4601EDF210FA"));
            System.out.println(CNTPCrypt.checkValid("exsitUser", "200001", "helloworld", "f936d81f609a01c51509252e948ea90cf12f2f4eaabcccc76d5bc03b6de64bb8"));
            System.out.println(CNTPCrypt.checkValid("", "", "1qaz@WSX", "654AFE22130011111111111C6563F77471C103C03BA1C2343974C108A1F20FB4601EDF210FA"));
            System.out.println(CNTPCrypt.checkValid("exsitUser", "200001", "helloworld", "f936d81111111111f609a01c51509252e948ea90cf12f2f4eaabcccc76d5bc03b6de64bb8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

