/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.epay.sdk;

import com.sinosoft.epay.sdk.EpaySignature;
import com.sinosoft.epay.sdk.Sign;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EpaySign
extends Sign {
    private static final Log logger = LogFactory.getLog(EpaySign.class);
    private Set<String> ipWhiteSet = new HashSet<String>();

    public void setIpWhileSet(String ipWhileListStr) {
        if (ipWhileListStr != null && !ipWhileListStr.contains(",")) {
            this.ipWhiteSet.add(ipWhileListStr);
        } else if (ipWhileListStr != null && ipWhileListStr.contains(",")) {
            String[] ips;
            for (String ip : ips = ipWhileListStr.split(",")) {
                this.ipWhiteSet.add(ip);
            }
        }
    }

    public Boolean checkIpWhiteList(String ip) {
        return this.ipWhiteSet.size() == 0 ? true : this.ipWhiteSet.contains(ip);
    }

    private EpaySign() {
    }

    private void init(String publicKey, String privateKey) {
        this.appPrivateKey = privateKey;
        this.epayPublicKey = publicKey;
        this.charset = "UTF-8";
    }

    public static EpaySign newInstance(String publicKey, String privateKey) {
        return EpaySign.newInstance(publicKey, privateKey, true);
    }

    public static EpaySign newInstance(String publicKey, String privateKey, Boolean isSingleton) {
        if ((publicKey == null || "".endsWith(publicKey)) && (privateKey == null || "".endsWith(privateKey))) {
            throw new RuntimeException("\u516c\u94a5\u548c\u79c1\u94a5\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u6216\u7a7a\u5b57\u7b26\u4e32");
        }
        if (privateKey != null && !"".endsWith(privateKey) && privateKey.length() < 1500) {
            throw new RuntimeException("\u79c1\u94a5\u957f\u5ea6\u4e0d\u6ee1\u8db3\u5b89\u5168\u8981\u6c42");
        }
        if (publicKey != null && !"".endsWith(publicKey) && publicKey.length() < 300) {
            throw new RuntimeException("\u516c\u94a5\u957f\u5ea6\u4e0d\u6ee1\u8db3\u5b89\u5168\u8981\u6c42");
        }
        EpaySign epaySign = null;
        epaySign = isSingleton != false ? EpaySignInner.epaySign : new EpaySign();
        epaySign.init(publicKey, privateKey);
        return epaySign;
    }

    @Override
    public String requestSign(Map<String, Object> head, Map<String, Object> body) {
        return this.requestSign(this.getSignCheckCotent(head, body));
    }

    @Override
    public String requestSign(String str) {
        if (this.appPrivateKey == null || "".endsWith(this.appPrivateKey)) {
            throw new RuntimeException("\u7b7e\u540d\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a\u6216\u7a7a\u5b57\u7b26\u4e32");
        }
        try {
            return EpaySignature.rsaSign(str, this.appPrivateKey, this.charset, "RSA2");
        }
        catch (Exception e) {
            logger.error((Object)"\u4f7f\u7528\u79c1\u94a5\u7b7e\u540d\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @Override
    public Boolean responeSignCheck(String str, String sign) {
        if (this.epayPublicKey == null || "".endsWith(this.epayPublicKey)) {
            throw new RuntimeException("\u9a8c\u7b7e\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a\u6216\u7a7a\u5b57\u7b26\u4e32");
        }
        try {
            return EpaySignature.rsa256CheckContent(str, sign, this.epayPublicKey, this.charset);
        }
        catch (Exception e) {
            logger.error((Object)"\u4f7f\u7528\u516c\u94a5\u9a8c\u7b7e\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getSignCheckCotent(Map<String, Object> head, Map<String, Object> body) {
        String valStr;
        HashMap<String, String> param = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : head.entrySet()) {
            valStr = this.getObjectStr(entry.getValue());
            param.put(entry.getKey(), valStr);
        }
        for (Map.Entry<String, Object> entry : body.entrySet()) {
            valStr = this.getObjectStr(entry.getValue());
            param.put(entry.getKey(), valStr);
        }
        String content = EpaySignature.getSignCheckContentV2(param);
        logger.info((Object)("\u670d\u52a1\u5668\u62fc\u63a5\u7b7e\u540d\u5b57\u7b26\u4e32\uff1a" + content));
        return content;
    }

    private String getObjectStr(Object val) {
        String valStr = "";
        if (this.isLinkedHashMap(val)) {
            HashMap<String, String> innerParams = new HashMap<String, String>();
            Map innerMaps = (Map)val;
            for (Map.Entry innerEntry : innerMaps.entrySet()) {
                innerParams.put((String)innerEntry.getKey(), this.getObjectStr(innerEntry.getValue()));
            }
            valStr = EpaySignature.getSignCheckContentV2(innerParams);
        } else if (this.isArrayList(val)) {
            List list = (List)val;
            ArrayList<String> innerList = new ArrayList<String>();
            for (Object obj : list) {
                innerList.add(this.getObjectStr(obj));
            }
            Collections.sort(innerList);
            valStr = ((Object)innerList).toString();
        } else if (val != null) {
            valStr = val + "";
        }
        return valStr;
    }

    private boolean isLinkedHashMap(Object val) {
        return null != val && (val.getClass().getName().contains("Map") || val.getClass().getName().contains("JSONObject"));
    }

    private boolean isArrayList(Object val) {
        return null != val && (val.getClass().getName().contains("List") || val.getClass().getName().contains("Array"));
    }

    private static class EpaySignInner {
        private static final EpaySign epaySign = new EpaySign();

        private EpaySignInner() {
        }
    }
}

