/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockUtil;
import com.facebook.presto.jdbc.internal.common.block.VariableWidthBlock;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.io.airlift.slice.XxHash64;

public abstract class AbstractVariableWidthBlock
implements Block {
    public abstract Slice getRawSlice(int var1);

    public abstract int getPositionOffset(int var1);

    protected abstract boolean isEntryNull(int var1);

    @Override
    public String getEncodingName() {
        return "VARIABLE_WIDTH";
    }

    @Override
    public byte getByte(int position) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getByte(this.getPositionOffset(position));
    }

    @Override
    public short getShort(int position) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getShort(this.getPositionOffset(position));
    }

    @Override
    public int getInt(int position) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getInt(this.getPositionOffset(position));
    }

    @Override
    public long getLong(int position) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getLong(this.getPositionOffset(position));
    }

    @Override
    public long getLong(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getLong(this.getPositionOffset(position) + offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).slice(this.getPositionOffset(position) + offset, length);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        this.checkReadablePosition(position);
        Slice rawSlice = this.getRawSlice(position);
        if (this.getSliceLength(position) < length) {
            return false;
        }
        return otherBlock.bytesEqual(otherPosition, otherOffset, rawSlice, this.getPositionOffset(position) + offset, length);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).equals(this.getPositionOffset(position) + offset, length, otherSlice, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        this.checkReadablePosition(position);
        return XxHash64.hash(this.getRawSlice(position), this.getPositionOffset(position) + offset, length);
    }

    @Override
    public int compareTo(int position, int offset, int length, Block otherBlock, int otherPosition, int otherOffset, int otherLength) {
        this.checkReadablePosition(position);
        Slice rawSlice = this.getRawSlice(position);
        if (this.getSliceLength(position) < length) {
            throw new IllegalArgumentException("Length longer than value length");
        }
        return -otherBlock.bytesCompare(otherPosition, otherOffset, otherLength, rawSlice, this.getPositionOffset(position) + offset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).compareTo(this.getPositionOffset(position) + offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.writeBytes(this.getRawSlice(position), this.getPositionOffset(position) + offset, length);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.writeBytesTo(position, 0, this.getSliceLength(position), blockBuilder);
        blockBuilder.closeEntry();
    }

    @Override
    public void writePositionTo(int position, SliceOutput output) {
        if (this.isNull(position)) {
            output.writeByte(0);
        } else {
            output.writeByte(1);
            int sliceLength = this.getSliceLength(position);
            output.writeInt(sliceLength);
            output.writeBytes(this.getRawSlice(position), this.getPositionOffset(position), sliceLength);
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        if (this.isNull(position)) {
            return new VariableWidthBlock(0, 1, Slices.EMPTY_SLICE, new int[]{0, 0}, new boolean[]{true});
        }
        int offset = this.getPositionOffset(position);
        int entrySize = this.getSliceLength(position);
        Slice copy = Slices.copyOf(this.getRawSlice(position), offset, entrySize);
        return new VariableWidthBlock(0, 1, copy, new int[]{0, copy.length()}, null);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : (long)this.getSliceLength(position);
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.isEntryNull(position);
    }

    protected void checkReadablePosition(int position) {
        BlockUtil.checkValidPosition(position, this.getPositionCount());
    }
}

