/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.predicate;

import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.predicate.AllOrNone;
import com.facebook.presto.jdbc.internal.common.predicate.DiscreteValues;
import com.facebook.presto.jdbc.internal.common.predicate.Marker;
import com.facebook.presto.jdbc.internal.common.predicate.Range;
import com.facebook.presto.jdbc.internal.common.predicate.Ranges;
import com.facebook.presto.jdbc.internal.common.predicate.ValueSet;
import com.facebook.presto.jdbc.internal.common.predicate.ValuesProcessor;
import com.facebook.presto.jdbc.internal.common.type.BooleanType;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SortedRangeSet
implements ValueSet {
    private final Type type;
    private final NavigableMap<Marker, Range> lowIndexedRanges;

    private SortedRangeSet(Type type, NavigableMap<Marker, Range> lowIndexedRanges) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(lowIndexedRanges, "lowIndexedRanges is null");
        if (!type.isOrderable()) {
            throw new IllegalArgumentException("Type is not orderable: " + type);
        }
        this.type = type;
        this.lowIndexedRanges = lowIndexedRanges;
    }

    static SortedRangeSet none(Type type) {
        return SortedRangeSet.copyOf(type, Collections.emptyList());
    }

    static SortedRangeSet all(Type type) {
        return SortedRangeSet.copyOf(type, Collections.singletonList(Range.all(type)));
    }

    static SortedRangeSet of(Type type, Object first, Object ... rest) {
        ArrayList<Range> ranges = new ArrayList<Range>(rest.length + 1);
        ranges.add(Range.equal(type, first));
        for (Object value : rest) {
            ranges.add(Range.equal(type, value));
        }
        return SortedRangeSet.copyOf(type, ranges);
    }

    static SortedRangeSet of(Range first, Range ... rest) {
        ArrayList<Range> rangeList = new ArrayList<Range>(rest.length + 1);
        rangeList.add(first);
        for (Range range : rest) {
            rangeList.add(range);
        }
        return SortedRangeSet.copyOf(first.getType(), rangeList);
    }

    static SortedRangeSet copyOf(Type type, Iterable<Range> ranges) {
        return new Builder(type).addAll(ranges).build();
    }

    @JsonCreator
    public static SortedRangeSet copyOf(@JsonProperty(value="type") Type type, @JsonProperty(value="ranges") List<Range> ranges) {
        return SortedRangeSet.copyOf(type, ranges);
    }

    @Override
    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="ranges")
    public List<Range> getOrderedRanges() {
        return new ArrayList<Range>(this.lowIndexedRanges.values());
    }

    public int getRangeCount() {
        return this.lowIndexedRanges.size();
    }

    @Override
    public boolean isNone() {
        return this.lowIndexedRanges.isEmpty();
    }

    @Override
    public boolean isAll() {
        return this.lowIndexedRanges.size() == 1 && ((Range)this.lowIndexedRanges.values().iterator().next()).isAll();
    }

    @Override
    public boolean isSingleValue() {
        return this.lowIndexedRanges.size() == 1 && ((Range)this.lowIndexedRanges.values().iterator().next()).isSingleValue();
    }

    @Override
    public Object getSingleValue() {
        if (!this.isSingleValue()) {
            throw new IllegalStateException("SortedRangeSet does not have just a single value");
        }
        return ((Range)this.lowIndexedRanges.values().iterator().next()).getSingleValue();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.includesMarker(Marker.exactly(this.type, value));
    }

    boolean includesMarker(Marker marker) {
        Objects.requireNonNull(marker, "marker is null");
        this.checkTypeCompatibility(marker);
        Map.Entry<Marker, Range> floorEntry = this.lowIndexedRanges.floorEntry(marker);
        return floorEntry != null && floorEntry.getValue().includes(marker);
    }

    public Range getSpan() {
        if (this.lowIndexedRanges.isEmpty()) {
            throw new IllegalStateException("Can not get span if no ranges exist");
        }
        return this.lowIndexedRanges.firstEntry().getValue().span(this.lowIndexedRanges.lastEntry().getValue());
    }

    @Override
    public Ranges getRanges() {
        return new Ranges(){

            @Override
            public int getRangeCount() {
                return SortedRangeSet.this.getRangeCount();
            }

            @Override
            public List<Range> getOrderedRanges() {
                return SortedRangeSet.this.getOrderedRanges();
            }

            @Override
            public Range getSpan() {
                return SortedRangeSet.this.getSpan();
            }
        };
    }

    @Override
    public ValuesProcessor getValuesProcessor() {
        return new ValuesProcessor(){

            @Override
            public <T> T transform(Function<Ranges, T> rangesFunction, Function<DiscreteValues, T> valuesFunction, Function<AllOrNone, T> allOrNoneFunction) {
                return rangesFunction.apply(SortedRangeSet.this.getRanges());
            }

            @Override
            public void consume(Consumer<Ranges> rangesConsumer, Consumer<DiscreteValues> valuesConsumer, Consumer<AllOrNone> allOrNoneConsumer) {
                rangesConsumer.accept(SortedRangeSet.this.getRanges());
            }
        };
    }

    @Override
    public SortedRangeSet intersect(ValueSet other) {
        SortedRangeSet otherRangeSet = this.checkCompatibility(other);
        Builder builder = new Builder(this.type);
        Iterator<Range> iterator1 = this.getOrderedRanges().iterator();
        Iterator<Range> iterator2 = otherRangeSet.getOrderedRanges().iterator();
        if (iterator1.hasNext() && iterator2.hasNext()) {
            Range range1 = iterator1.next();
            Range range2 = iterator2.next();
            while (true) {
                if (range1.overlaps(range2)) {
                    builder.add(range1.intersect(range2));
                }
                if (range1.getHigh().compareTo(range2.getHigh()) <= 0) {
                    if (!iterator1.hasNext()) break;
                    range1 = iterator1.next();
                    continue;
                }
                if (!iterator2.hasNext()) break;
                range2 = iterator2.next();
            }
        }
        return builder.build();
    }

    @Override
    public SortedRangeSet union(ValueSet other) {
        SortedRangeSet otherRangeSet = this.checkCompatibility(other);
        return new Builder(this.type).addAll(this.getOrderedRanges()).addAll(otherRangeSet.getOrderedRanges()).build();
    }

    @Override
    public SortedRangeSet union(Collection<ValueSet> valueSets) {
        Builder builder = new Builder(this.type);
        builder.addAll(this.getOrderedRanges());
        for (ValueSet valueSet : valueSets) {
            builder.addAll(this.checkCompatibility(valueSet).getOrderedRanges());
        }
        return builder.build();
    }

    @Override
    public SortedRangeSet complement() {
        Builder builder = new Builder(this.type);
        if (this.lowIndexedRanges.isEmpty()) {
            return builder.add(Range.all(this.type)).build();
        }
        Iterator rangeIterator = this.lowIndexedRanges.values().iterator();
        Range firstRange = (Range)rangeIterator.next();
        if (!firstRange.getLow().isLowerUnbounded()) {
            builder.add(new Range(Marker.lowerUnbounded(this.type), firstRange.getLow().lesserAdjacent()));
        }
        Range previousRange = firstRange;
        while (rangeIterator.hasNext()) {
            Range currentRange = (Range)rangeIterator.next();
            Marker lowMarker = previousRange.getHigh().greaterAdjacent();
            Marker highMarker = currentRange.getLow().lesserAdjacent();
            builder.add(new Range(lowMarker, highMarker));
            previousRange = currentRange;
        }
        Range lastRange = previousRange;
        if (!lastRange.getHigh().isUpperUnbounded()) {
            builder.add(new Range(lastRange.getHigh().greaterAdjacent(), Marker.upperUnbounded(this.type)));
        }
        return builder.build();
    }

    private SortedRangeSet checkCompatibility(ValueSet other) {
        if (!this.getType().equals(other.getType())) {
            throw new IllegalStateException(String.format("Mismatched types: %s vs %s", this.getType(), other.getType()));
        }
        if (!(other instanceof SortedRangeSet)) {
            throw new IllegalStateException(String.format("ValueSet is not a SortedRangeSet: %s", other.getClass()));
        }
        return (SortedRangeSet)other;
    }

    private void checkTypeCompatibility(Marker marker) {
        if (!this.getType().equals(marker.getType())) {
            throw new IllegalStateException(String.format("Marker of %s does not match SortedRangeSet of %s", marker.getType(), this.getType()));
        }
    }

    public int hashCode() {
        return Objects.hash(this.lowIndexedRanges);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SortedRangeSet other = (SortedRangeSet)obj;
        return Objects.equals(this.lowIndexedRanges, other.lowIndexedRanges);
    }

    @Override
    public String toString(SqlFunctionProperties properties) {
        return "[" + this.lowIndexedRanges.values().stream().map(range -> range.toString(properties)).collect(Collectors.joining(", ")) + "]";
    }

    static class Builder {
        private final Type type;
        private final List<Range> ranges = new ArrayList<Range>();

        Builder(Type type) {
            Objects.requireNonNull(type, "type is null");
            if (!type.isOrderable()) {
                throw new IllegalArgumentException("Type is not orderable: " + type);
            }
            this.type = type;
        }

        Builder add(Range range) {
            if (!this.type.equals(range.getType())) {
                throw new IllegalArgumentException(String.format("Range type %s does not match builder type %s", range.getType(), this.type));
            }
            this.ranges.add(range);
            return this;
        }

        Builder addAll(Iterable<Range> ranges) {
            for (Range range : ranges) {
                this.add(range);
            }
            return this;
        }

        SortedRangeSet build() {
            Collections.sort(this.ranges, Comparator.comparing(Range::getLow));
            TreeMap<Marker, Range> result = new TreeMap<Marker, Range>();
            Range current = null;
            for (Range next : this.ranges) {
                if (current == null) {
                    current = next;
                    continue;
                }
                if (current.overlaps(next) || current.getHigh().isAdjacent(next.getLow())) {
                    current = current.span(next);
                    continue;
                }
                result.put(current.getLow(), current);
                current = next;
            }
            if (current != null) {
                result.put(current.getLow(), current);
            }
            if (this.type == BooleanType.BOOLEAN) {
                boolean trueAllowed = false;
                boolean falseAllowed = false;
                for (Map.Entry entry : result.entrySet()) {
                    if (((Range)entry.getValue()).includes(Marker.exactly(BooleanType.BOOLEAN, true))) {
                        trueAllowed = true;
                    }
                    if (!((Range)entry.getValue()).includes(Marker.exactly(BooleanType.BOOLEAN, false))) continue;
                    falseAllowed = true;
                }
                if (trueAllowed && falseAllowed) {
                    result = new TreeMap();
                    result.put(Range.all(BooleanType.BOOLEAN).getLow(), Range.all(BooleanType.BOOLEAN));
                    return new SortedRangeSet(BooleanType.BOOLEAN, result);
                }
            }
            return new SortedRangeSet(this.type, result);
        }
    }
}

