/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.type.TimeZoneKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import java.util.Objects;

public class ConnectorSession {
    private final String user;
    private final String source;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final String remoteUserAddress;
    private final String userAgent;
    private final String catalog;
    private final String schema;
    private final long startTime;

    public ConnectorSession(String user, String source, String catalog, String schema, TimeZoneKey timeZoneKey, Locale locale, String remoteUserAddress, String userAgent) {
        this(user, source, catalog, schema, timeZoneKey, locale, remoteUserAddress, userAgent, System.currentTimeMillis());
    }

    @JsonCreator
    public ConnectorSession(@JsonProperty(value="user") String user, @JsonProperty(value="source") String source, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schema") String schema, @JsonProperty(value="timeZoneKey") TimeZoneKey timeZoneKey, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="remoteUserAddress") String remoteUserAddress, @JsonProperty(value="userAgent") String userAgent, @JsonProperty(value="startTime") long startTime) {
        this.user = user;
        this.source = source;
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = locale;
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.remoteUserAddress = remoteUserAddress;
        this.userAgent = userAgent;
        this.startTime = startTime;
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public String getSource() {
        return this.source;
    }

    @Deprecated
    @JsonProperty
    public String getCatalog() {
        return this.catalog;
    }

    @Deprecated
    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    @JsonProperty
    public Locale getLocale() {
        return this.locale;
    }

    @JsonProperty
    public String getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    @JsonProperty
    public String getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty
    public long getStartTime() {
        return this.startTime;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Session{");
        builder.append("user='").append(this.user).append('\'');
        builder.append(", source='").append(this.source).append('\'');
        builder.append(", remoteUserAddress='").append(this.remoteUserAddress).append('\'');
        builder.append(", userAgent='").append(this.userAgent).append('\'');
        builder.append(", catalog='").append(this.catalog).append('\'');
        builder.append(", schema='").append(this.schema).append('\'');
        builder.append(", timeZoneKey=").append(this.timeZoneKey);
        builder.append(", locale=").append(this.locale);
        builder.append(", startTime=").append(this.startTime);
        builder.append('}');
        return builder.toString();
    }
}

