/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.FixedWidthBlock;
import com.facebook.presto.spi.block.FixedWidthBlockEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public abstract class AbstractFixedWidthBlock
implements Block {
    protected final int fixedSize;

    protected AbstractFixedWidthBlock(int fixedSize) {
        if (fixedSize < 0) {
            throw new IllegalArgumentException("fixedSize is negative");
        }
        this.fixedSize = fixedSize;
    }

    protected abstract Slice getRawSlice();

    protected abstract boolean isEntryNull(int var1);

    public int getFixedSize() {
        return this.fixedSize;
    }

    @Override
    public int getLength(int position) {
        return this.fixedSize;
    }

    @Override
    public byte getByte(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice().getByte(this.valueOffset(position) + offset);
    }

    @Override
    public short getShort(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice().getShort(this.valueOffset(position) + offset);
    }

    @Override
    public int getInt(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice().getInt(this.valueOffset(position) + offset);
    }

    @Override
    public long getLong(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice().getLong(this.valueOffset(position) + offset);
    }

    @Override
    public float getFloat(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice().getFloat(this.valueOffset(position) + offset);
    }

    @Override
    public double getDouble(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice().getDouble(this.valueOffset(position) + offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        this.checkReadablePosition(position);
        return this.getRawSlice().slice(this.valueOffset(position) + offset, length);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        this.checkReadablePosition(position);
        if (this.fixedSize < length) {
            return false;
        }
        int thisOffset = this.valueOffset(position) + offset;
        return otherBlock.bytesEqual(otherPosition, otherOffset, this.getRawSlice(), thisOffset, length);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        this.checkReadablePosition(position);
        int thisOffset = this.valueOffset(position) + offset;
        return this.getRawSlice().equals(thisOffset, length, otherSlice, otherOffset, length);
    }

    @Override
    public int hash(int position, int offset, int length) {
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            return 0;
        }
        return this.getRawSlice().hashCode(this.valueOffset(position) + offset, length);
    }

    @Override
    public int compareTo(int position, int offset, int length, Block otherBlock, int otherPosition, int otherOffset, int otherLength) {
        this.checkReadablePosition(position);
        if (this.fixedSize < length) {
            throw new IllegalArgumentException("Length longer than value length");
        }
        int thisOffset = this.valueOffset(position) + offset;
        return -otherBlock.bytesCompare(otherPosition, otherOffset, otherLength, this.getRawSlice(), thisOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        this.checkReadablePosition(position);
        return this.getRawSlice().compareTo(this.valueOffset(position) + offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.writeBytes(this.getRawSlice(), this.valueOffset(position) + offset, length);
    }

    @Override
    public BlockEncoding getEncoding() {
        return new FixedWidthBlockEncoding(this.fixedSize);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        Slice copy = Slices.copyOf((Slice)this.getRawSlice(), (int)this.valueOffset(position), (int)this.fixedSize);
        return new FixedWidthBlock(this.fixedSize, 1, copy, new boolean[]{this.isNull(position)});
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.isEntryNull(position);
    }

    private int valueOffset(int position) {
        return position * this.fixedSize;
    }

    protected void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

