/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.cache.service;

import com.fhs.cache.service.RedisCacheService;
import com.fhs.common.utils.ConverterUtils;
import com.fhs.common.utils.JsonUtils;
import com.fhs.trans.service.impl.RpcTransService;
import com.fhs.trans.service.impl.SimpleTransService;
import java.util.HashMap;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public class TransCacheManager {
    @Autowired(required=false)
    private RpcTransService rpcTransService;
    @Autowired(required=false)
    private SimpleTransService simpleTransService;
    @Autowired(required=false)
    private RedisCacheService<String> redisCacheService;

    public void clearCache(Class targetClass, Object pkey) {
        if (Objects.nonNull(this.simpleTransService)) {
            this.simpleTransService.clearGlobalCache(pkey, targetClass.getName(), "simple");
        }
        if (Objects.nonNull(this.rpcTransService)) {
            this.rpcTransService.clearGlobalCache(pkey, targetClass.getName(), "rpc");
        }
        if (Objects.nonNull(this.redisCacheService)) {
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("messageType", "clear");
            body.put("target", targetClass.getName());
            body.put("pkey", ConverterUtils.toString(pkey));
            body.put("transType", "simple");
            this.redisCacheService.convertAndSend("trans", JsonUtils.map2json(body));
            body.put("transType", "rpc");
            this.redisCacheService.convertAndSend("trans", JsonUtils.map2json(body));
        }
    }

    public void setRpcTransCache(String targetClassName, SimpleTransService.TransCacheSett cacheSett) {
        this.rpcTransService.setTransCache(targetClassName, cacheSett);
    }

    public void setUniqueFieldCache(String targetClassName, String uniqueField) {
        this.simpleTransService.setUniqueFieldCache(targetClassName, uniqueField);
    }
}

