/*
 * Decompiled with CFR 0.152.
 */
package com.fit2cloud.quartz.config;

import com.fit2cloud.quartz.config.ClusterQuartzFixedDelayJobBean;
import com.fit2cloud.quartz.util.ClassUtils;
import com.fit2cloud.quartz.util.QuartzBeanFactory;
import java.lang.reflect.Method;
import org.quartz.JobExecutionContext;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
public class ClusterQuartzJobBean
extends QuartzJobBean {
    private Logger logger = LoggerFactory.getLogger(ClusterQuartzFixedDelayJobBean.class);
    private String targetObject;
    private String targetMethod;
    private Object[] params;

    protected void executeInternal(JobExecutionContext context) {
        try {
            this.logger.debug("The scheduled task starts\uff1atargetObject={}, targetMethod={}", (Object)this.targetObject, (Object)this.targetMethod);
            Object targetObject = QuartzBeanFactory.getBean(this.targetObject);
            Method m = targetObject.getClass().getMethod(this.targetMethod, ClassUtils.toClass(this.params));
            m.invoke(targetObject, this.params);
            this.logger.debug("The scheduled task ends normally\uff1atargetObject={}, targetMethod={}", (Object)this.targetObject, (Object)this.targetMethod);
        }
        catch (Exception e) {
            this.logger.error("The scheduled task execution failed\uff1atargetObject=" + this.targetObject + ", targetMethod=" + this.targetMethod, (Throwable)e);
        }
    }

    public void setTargetObject(String targetObject) {
        this.targetObject = targetObject;
    }

    public void setTargetMethod(String targetMethod) {
        this.targetMethod = targetMethod;
    }

    public void setParams(Object ... params) {
        this.params = params;
    }
}

