/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.GBaseIO;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ExportControlled {
    private static final String SQL_STATE_BAD_SSL_PARAMS = "08000";

    protected static boolean enabled() {
        return true;
    }

    protected static void transformSocketToSSLSocket(GBaseIO gbaseIO) throws SQLException {
        SSLSocketFactory sslFact = ExportControlled.getSSLSocketFactoryDefaultOrConfigured(gbaseIO);
        try {
            gbaseIO.gbaseConnection = sslFact.createSocket(gbaseIO.gbaseConnection, gbaseIO.host, gbaseIO.port, true);
            ((SSLSocket)gbaseIO.gbaseConnection).setEnabledProtocols(new String[]{"TLSv1"});
            ((SSLSocket)gbaseIO.gbaseConnection).startHandshake();
            gbaseIO.gbaseInput = gbaseIO.connection.getUseUnbufferedInput() ? gbaseIO.gbaseConnection.getInputStream() : new BufferedInputStream(gbaseIO.gbaseConnection.getInputStream(), 16384);
            gbaseIO.gbaseOutput = new BufferedOutputStream(gbaseIO.gbaseConnection.getOutputStream(), 16384);
            gbaseIO.gbaseOutput.flush();
        }
        catch (IOException ioEx) {
            throw SQLError.createCommunicationsException(gbaseIO.connection, gbaseIO.getLastPacketSentTimeMs(), gbaseIO.getLastPacketReceivedTimeMs(), ioEx, gbaseIO.getExceptionInterceptor());
        }
    }

    private ExportControlled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLSocketFactory getSSLSocketFactoryDefaultOrConfigured(GBaseIO gbaseIO) throws SQLException {
        KeyManagerFactory kmf;
        TrustManagerFactory tmf;
        String clientCertificateKeyStoreUrl;
        block30: {
            char[] password;
            URL ksURL;
            clientCertificateKeyStoreUrl = gbaseIO.connection.getClientCertificateKeyStoreUrl();
            String trustCertificateKeyStoreUrl = gbaseIO.connection.getTrustCertificateKeyStoreUrl();
            String clientCertificateKeyStoreType = gbaseIO.connection.getClientCertificateKeyStoreType();
            String clientCertificateKeyStorePassword = gbaseIO.connection.getClientCertificateKeyStorePassword();
            String trustCertificateKeyStoreType = gbaseIO.connection.getTrustCertificateKeyStoreType();
            String trustCertificateKeyStorePassword = gbaseIO.connection.getTrustCertificateKeyStorePassword();
            if (StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl) && StringUtils.isNullOrEmpty(trustCertificateKeyStoreUrl) && gbaseIO.connection.getVerifyServerCertificate()) {
                return (SSLSocketFactory)SSLSocketFactory.getDefault();
            }
            tmf = null;
            kmf = null;
            try {
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            }
            catch (NoSuchAlgorithmException nsae) {
                throw SQLError.createSQLException("Default algorithm definitions for TrustManager and/or KeyManager are invalid.  Check java security properties file.", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
            }
            if (!StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl)) {
                try {
                    if (!StringUtils.isNullOrEmpty(clientCertificateKeyStoreType)) {
                        KeyStore clientKeyStore = KeyStore.getInstance(clientCertificateKeyStoreType);
                        ksURL = new URL(clientCertificateKeyStoreUrl);
                        password = clientCertificateKeyStorePassword == null ? new char[]{} : clientCertificateKeyStorePassword.toCharArray();
                        clientKeyStore.load(ksURL.openStream(), password);
                        kmf.init(clientKeyStore, password);
                    }
                }
                catch (UnrecoverableKeyException uke) {
                    throw SQLError.createSQLException("Could not recover keys from client keystore.  Check password?", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw SQLError.createSQLException("Unsupported keystore algorithm [" + nsae.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
                }
                catch (KeyStoreException kse) {
                    throw SQLError.createSQLException("Could not create KeyStore instance [" + kse.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
                }
                catch (CertificateException nsae) {
                    throw SQLError.createSQLException("Could not load client" + clientCertificateKeyStoreType + " keystore from " + clientCertificateKeyStoreUrl, gbaseIO.getExceptionInterceptor());
                }
                catch (MalformedURLException mue) {
                    throw SQLError.createSQLException(clientCertificateKeyStoreUrl + " does not appear to be a valid URL.", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
                }
                catch (IOException ioe) {
                    SQLException sqlEx = SQLError.createSQLException("Cannot open " + clientCertificateKeyStoreUrl + " [" + ioe.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
                    sqlEx.initCause(ioe);
                    throw sqlEx;
                }
            }
            if (StringUtils.isNullOrEmpty(trustCertificateKeyStoreUrl)) break block30;
            try {
                if (StringUtils.isNullOrEmpty(trustCertificateKeyStoreType)) break block30;
                KeyStore trustKeyStore = KeyStore.getInstance(trustCertificateKeyStoreType);
                ksURL = new URL(trustCertificateKeyStoreUrl);
                password = trustCertificateKeyStorePassword == null ? new char[]{} : trustCertificateKeyStorePassword.toCharArray();
                InputStream is = null;
                try {
                    is = ksURL.openStream();
                    trustKeyStore.load(is, password);
                    Object var14_28 = null;
                }
                catch (Throwable throwable) {
                    Object var14_29 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
                tmf.init(trustKeyStore);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw SQLError.createSQLException("Unsupported keystore algorithm [" + nsae.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
            }
            catch (KeyStoreException kse) {
                throw SQLError.createSQLException("Could not create KeyStore instance [" + kse.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
            }
            catch (CertificateException nsae) {
                throw SQLError.createSQLException("Could not load trust" + trustCertificateKeyStoreType + " keystore from " + trustCertificateKeyStoreUrl, SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
            }
            catch (MalformedURLException mue) {
                throw SQLError.createSQLException(trustCertificateKeyStoreUrl + " does not appear to be a valid URL.", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
            }
            catch (IOException ioe) {
                SQLException sqlEx = SQLError.createSQLException("Cannot open " + trustCertificateKeyStoreUrl + " [" + ioe.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
                sqlEx.initCause(ioe);
                throw sqlEx;
            }
        }
        SSLContext sslContext = null;
        try {
            TrustManager[] trustManagerArray;
            sslContext = SSLContext.getInstance("TLS");
            KeyManager[] keyManagerArray = StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl) ? null : kmf.getKeyManagers();
            if (gbaseIO.connection.getVerifyServerCertificate()) {
                trustManagerArray = tmf.getTrustManagers();
            } else {
                X509TrustManager[] x509TrustManagerArray = new X509TrustManager[1];
                trustManagerArray = x509TrustManagerArray;
                x509TrustManagerArray[0] = new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
            }
            sslContext.init(keyManagerArray, trustManagerArray, null);
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw SQLError.createSQLException("TLS is not a valid SSL protocol.", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
        }
        catch (KeyManagementException kme) {
            throw SQLError.createSQLException("KeyManagementException: " + kme.getMessage(), SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
        }
    }
}

