/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.CharsetMapping;
import com.gbase.jdbc.GBaseConnection;
import com.gbase.jdbc.GBaseDefs;
import com.gbase.jdbc.Messages;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.SingleByteCharsetConverter;
import com.gbase.jdbc.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.PatternSyntaxException;

public class Field {
    private static final int AUTO_INCREMENT_FLAG = 512;
    private static final int NO_CHARSET_INFO = -1;
    private byte[] buffer;
    private int charsetIndex = 0;
    private String charsetName = null;
    private int colDecimals;
    private short colFlag;
    private String collationName = null;
    private GBaseConnection connection = null;
    private String databaseName = null;
    private int databaseNameLength = -1;
    private int databaseNameStart = -1;
    private int defaultValueLength = -1;
    private int defaultValueStart = -1;
    private String fullName = null;
    private String fullOriginalName = null;
    private boolean isImplicitTempTable = false;
    private long length;
    private int gbaseType = -1;
    private String name;
    private int nameLength;
    private int nameStart;
    private String originalColumnName = null;
    private int originalColumnNameLength = -1;
    private int originalColumnNameStart = -1;
    private String originalTableName = null;
    private int originalTableNameLength = -1;
    private int originalTableNameStart = -1;
    private int precisionAdjustFactor = 0;
    private int sqlType = -1;
    private String tableName;
    private int tableNameLength;
    private int tableNameStart;
    private boolean useOldNameMetadata = false;
    private boolean isSingleBit;
    private int maxBytesPerChar;

    Field(GBaseConnection conn, byte[] buffer, int databaseNameStart, int databaseNameLength, int tableNameStart, int tableNameLength, int originalTableNameStart, int originalTableNameLength, int nameStart, int nameLength, int originalColumnNameStart, int originalColumnNameLength, long length, int gbaseType, short colFlag, int colDecimals, int defaultValueStart, int defaultValueLength, int charsetIndex) throws SQLException {
        boolean isFromFunction;
        this.connection = conn;
        this.buffer = buffer;
        this.nameStart = nameStart;
        this.nameLength = nameLength;
        this.tableNameStart = tableNameStart;
        this.tableNameLength = tableNameLength;
        this.length = length;
        this.colFlag = colFlag;
        this.colDecimals = colDecimals;
        this.gbaseType = gbaseType;
        this.databaseNameStart = databaseNameStart;
        this.databaseNameLength = databaseNameLength;
        this.originalTableNameStart = originalTableNameStart;
        this.originalTableNameLength = originalTableNameLength;
        this.originalColumnNameStart = originalColumnNameStart;
        this.originalColumnNameLength = originalColumnNameLength;
        this.defaultValueStart = defaultValueStart;
        this.defaultValueLength = defaultValueLength;
        this.charsetIndex = charsetIndex;
        this.sqlType = GBaseDefs.gbaseToJavaType(this.gbaseType);
        this.checkForImplicitTemporaryTable();
        boolean bl = isFromFunction = this.originalTableNameLength == 0;
        if (this.gbaseType == 252) {
            if (this.connection != null && this.connection.getBlobsAreStrings() || this.connection.getFunctionsNeverReturnBlobs() && isFromFunction) {
                this.sqlType = 12;
                this.gbaseType = 15;
            } else if (this.charsetIndex == 63 || !this.connection.versionMeetsMinimum(4, 1, 0)) {
                if (this.connection.getUseBlobToStoreUTF8OutsideBMP() && this.shouldSetupForUtf8StringInBlob()) {
                    this.setupForUtf8StringInBlob();
                } else {
                    this.setBlobTypeBasedOnLength();
                    this.sqlType = GBaseDefs.gbaseToJavaType(this.gbaseType);
                }
            } else {
                this.gbaseType = 253;
                this.sqlType = -1;
            }
        }
        if (this.sqlType == -6 && this.length == 1L && this.connection.getTinyInt1isBit() && conn.getTinyInt1isBit()) {
            this.sqlType = conn.getTransformedBitIsBoolean() ? 16 : -7;
        }
        if (!this.isNativeNumericType() && !this.isNativeDateTimeType()) {
            this.charsetName = this.connection.getCharsetNameForIndex(this.charsetIndex);
            boolean isBinary = this.isBinary();
            if (this.connection.versionMeetsMinimum(4, 1, 0) && this.gbaseType == 253 && isBinary && this.charsetIndex == 63) {
                if (this.connection != null && this.connection.getFunctionsNeverReturnBlobs() && isFromFunction) {
                    this.sqlType = 12;
                    this.gbaseType = 15;
                } else if (this.isOpaqueBinary()) {
                    this.sqlType = -3;
                }
            }
            if (this.connection.versionMeetsMinimum(4, 1, 0) && this.gbaseType == 254 && isBinary && this.charsetIndex == 63 && this.isOpaqueBinary() && !this.connection.getBlobsAreStrings()) {
                this.sqlType = -2;
            }
            if (this.gbaseType == 16) {
                boolean bl2 = this.isSingleBit = this.length == 0L;
                if (this.connection != null && (this.connection.versionMeetsMinimum(5, 0, 21) || this.connection.versionMeetsMinimum(5, 1, 10)) && this.length == 1L) {
                    this.isSingleBit = true;
                }
                if (this.isSingleBit) {
                    this.sqlType = -7;
                } else {
                    this.sqlType = -3;
                    this.colFlag = (short)(this.colFlag | 0x80);
                    this.colFlag = (short)(this.colFlag | 0x10);
                    isBinary = true;
                }
            }
            if (this.sqlType == -4 && !isBinary) {
                this.sqlType = -1;
            } else if (this.sqlType == -3 && !isBinary) {
                this.sqlType = 12;
            }
        } else {
            this.charsetName = "US-ASCII";
        }
        if (!this.isUnsigned()) {
            switch (this.gbaseType) {
                case 0: 
                case 246: {
                    this.precisionAdjustFactor = -1;
                    break;
                }
                case 4: 
                case 5: {
                    this.precisionAdjustFactor = 1;
                }
            }
        } else {
            switch (this.gbaseType) {
                case 4: 
                case 5: {
                    this.precisionAdjustFactor = 1;
                }
            }
        }
    }

    private boolean shouldSetupForUtf8StringInBlob() throws SQLException {
        block9: {
            String includePattern = this.connection.getUtf8OutsideBmpIncludedColumnNamePattern();
            String excludePattern = this.connection.getUtf8OutsideBmpExcludedColumnNamePattern();
            if (excludePattern != null && !StringUtils.isEmptyOrWhitespaceOnly(excludePattern)) {
                try {
                    if (!this.getOriginalName().matches(excludePattern)) break block9;
                    if (includePattern != null && !StringUtils.isEmptyOrWhitespaceOnly(includePattern)) {
                        try {
                            if (this.getOriginalName().matches(includePattern)) {
                                return true;
                            }
                        }
                        catch (PatternSyntaxException pse) {
                            SQLException sqlEx = SQLError.createSQLException("Illegal regex specified for \"utf8OutsideBmpIncludedColumnNamePattern\"", "S1009", this.connection.getExceptionInterceptor());
                            if (!this.connection.getParanoid()) {
                                sqlEx.initCause(pse);
                            }
                            throw sqlEx;
                        }
                    }
                    return false;
                }
                catch (PatternSyntaxException pse) {
                    SQLException sqlEx = SQLError.createSQLException("Illegal regex specified for \"utf8OutsideBmpExcludedColumnNamePattern\"", "S1009", this.connection.getExceptionInterceptor());
                    if (!this.connection.getParanoid()) {
                        sqlEx.initCause(pse);
                    }
                    throw sqlEx;
                }
            }
        }
        return true;
    }

    private void setupForUtf8StringInBlob() {
        if (this.length == 255L || this.length == 65535L) {
            this.gbaseType = 15;
            this.sqlType = 12;
        } else {
            this.gbaseType = 253;
            this.sqlType = -1;
        }
        this.charsetIndex = 33;
    }

    Field(GBaseConnection conn, byte[] buffer, int nameStart, int nameLength, int tableNameStart, int tableNameLength, int length, int gbaseType, short colFlag, int colDecimals) throws SQLException {
        this(conn, buffer, -1, -1, tableNameStart, tableNameLength, -1, -1, nameStart, nameLength, -1, -1, length, gbaseType, colFlag, colDecimals, -1, -1, -1);
    }

    Field(String tableName, String columnName, int jdbcType, int length) {
        this.tableName = tableName;
        this.name = columnName;
        this.length = length;
        this.sqlType = jdbcType;
        this.colFlag = 0;
        this.colDecimals = 0;
    }

    Field(String tableName, String columnName, int charsetIndex, int jdbcType, int length) {
        this.tableName = tableName;
        this.name = columnName;
        this.length = length;
        this.sqlType = jdbcType;
        this.colFlag = 0;
        this.colDecimals = 0;
        this.charsetIndex = charsetIndex;
        switch (this.sqlType) {
            case -3: 
            case -2: {
                this.colFlag = (short)(this.colFlag | 0x80);
                this.colFlag = (short)(this.colFlag | 0x10);
            }
        }
    }

    private void checkForImplicitTemporaryTable() {
        this.isImplicitTempTable = this.tableNameLength > 5 && this.buffer[this.tableNameStart] == 35 && this.buffer[this.tableNameStart + 1] == 115 && this.buffer[this.tableNameStart + 2] == 113 && this.buffer[this.tableNameStart + 3] == 108 && this.buffer[this.tableNameStart + 4] == 95;
    }

    public String getCharacterSet() throws SQLException {
        return this.charsetName;
    }

    public void setCharacterSet(String javaEncodingName) throws SQLException {
        this.charsetName = javaEncodingName;
        this.charsetIndex = CharsetMapping.getCharsetIndexForGBaseEncodingName(javaEncodingName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String getCollation() throws SQLException {
        if (this.collationName != null || this.connection == null || !this.connection.versionMeetsMinimum(4, 1, 0)) return this.collationName;
        if (this.connection.getUseDynamicCharsetInfo()) {
            Statement collationStmt;
            block14: {
                DatabaseMetaData dbmd = this.connection.getMetaData();
                String quotedIdStr = dbmd.getIdentifierQuoteString();
                if (" ".equals(quotedIdStr)) {
                    quotedIdStr = "";
                }
                String csCatalogName = this.getDatabaseName();
                String csTableName = this.getOriginalTableName();
                String csColumnName = this.getOriginalName();
                if (csCatalogName == null || csCatalogName.length() == 0 || csTableName == null || csTableName.length() == 0 || csColumnName == null || csColumnName.length() == 0) return this.collationName;
                StringBuffer queryBuf = new StringBuffer(csCatalogName.length() + csTableName.length() + 28);
                queryBuf.append("SHOW FULL COLUMNS FROM ");
                queryBuf.append(quotedIdStr);
                queryBuf.append(csCatalogName);
                queryBuf.append(quotedIdStr);
                queryBuf.append(".");
                queryBuf.append(quotedIdStr);
                queryBuf.append(csTableName);
                queryBuf.append(quotedIdStr);
                collationStmt = null;
                ResultSet collationRs = null;
                try {
                    try {
                        collationStmt = this.connection.createStatement();
                        collationRs = collationStmt.executeQuery(queryBuf.toString());
                        while (collationRs.next()) {
                            if (!csColumnName.equals(collationRs.getString("Field"))) continue;
                            this.collationName = collationRs.getString("Collation");
                            break;
                        }
                    }
                    catch (Exception e) {
                        collationRs = collationStmt.executeQuery("show variables like 'collation_database'");
                        if (collationRs.next()) {
                            this.collationName = collationRs.getString(2);
                        }
                        Object var11_10 = null;
                        if (collationRs != null) {
                            collationRs.close();
                            collationRs = null;
                        }
                        if (collationStmt == null) return this.collationName;
                        collationStmt.close();
                        return this.collationName;
                    }
                    Object var11_9 = null;
                    if (collationRs == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (collationRs != null) {
                        collationRs.close();
                        collationRs = null;
                    }
                    if (collationStmt == null) throw throwable;
                    collationStmt.close();
                    collationStmt = null;
                    throw throwable;
                }
                collationRs.close();
                collationRs = null;
            }
            if (collationStmt == null) return this.collationName;
            collationStmt.close();
            return this.collationName;
        }
        this.collationName = CharsetMapping.INDEX_TO_COLLATION[this.charsetIndex];
        return this.collationName;
    }

    public String getColumnLabel() throws SQLException {
        return this.getName();
    }

    public String getDatabaseName() throws SQLException {
        if (this.databaseName == null && this.databaseNameStart != -1 && this.databaseNameLength != -1) {
            this.databaseName = this.getStringFromBytes(this.databaseNameStart, this.databaseNameLength);
        }
        return this.databaseName;
    }

    int getDecimals() {
        return this.colDecimals;
    }

    public String getFullName() throws SQLException {
        if (this.fullName == null) {
            StringBuffer fullNameBuf = new StringBuffer(this.getTableName().length() + 1 + this.getName().length());
            fullNameBuf.append(this.tableName);
            fullNameBuf.append('.');
            fullNameBuf.append(this.name);
            this.fullName = fullNameBuf.toString();
            Object var1_1 = null;
        }
        return this.fullName;
    }

    public String getFullOriginalName() throws SQLException {
        this.getOriginalName();
        if (this.originalColumnName == null) {
            return null;
        }
        if (this.fullName == null) {
            StringBuffer fullOriginalNameBuf = new StringBuffer(this.getOriginalTableName().length() + 1 + this.getOriginalName().length());
            fullOriginalNameBuf.append(this.originalTableName);
            fullOriginalNameBuf.append('.');
            fullOriginalNameBuf.append(this.originalColumnName);
            this.fullOriginalName = fullOriginalNameBuf.toString();
            Object var1_1 = null;
        }
        return this.fullOriginalName;
    }

    public long getLength() {
        return this.length;
    }

    public synchronized int getMaxBytesPerCharacter() throws SQLException {
        if (this.maxBytesPerChar == 0) {
            this.maxBytesPerChar = this.connection.getMaxBytesPerChar(this.getCharacterSet());
        }
        return this.maxBytesPerChar;
    }

    public int getGBaseType() {
        return this.gbaseType;
    }

    public String getName() throws SQLException {
        if (this.name == null) {
            this.name = this.getStringFromBytes(this.nameStart, this.nameLength);
        }
        return this.name;
    }

    public String getNameNoAliases() throws SQLException {
        if (this.useOldNameMetadata) {
            return this.getName();
        }
        if (this.connection != null && this.connection.versionMeetsMinimum(4, 1, 0)) {
            return this.getOriginalName();
        }
        return this.getName();
    }

    public String getOriginalName() throws SQLException {
        if (this.originalColumnName == null && this.originalColumnNameStart != -1 && this.originalColumnNameLength != -1) {
            this.originalColumnName = this.getStringFromBytes(this.originalColumnNameStart, this.originalColumnNameLength);
        }
        return this.originalColumnName;
    }

    public String getOriginalTableName() throws SQLException {
        if (this.originalTableName == null && this.originalTableNameStart != -1 && this.originalTableNameLength != -1) {
            this.originalTableName = this.getStringFromBytes(this.originalTableNameStart, this.originalTableNameLength);
        }
        return this.originalTableName;
    }

    public int getPrecisionAdjustFactor() {
        return this.precisionAdjustFactor;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    private String getStringFromBytes(int stringStart, int stringLength) throws SQLException {
        if (stringStart == -1 || stringLength == -1) {
            return null;
        }
        String stringVal = null;
        if (this.connection != null) {
            if (this.connection.getUseUnicode()) {
                String encoding = this.connection.getCharacterSetMetadata();
                if (encoding == null) {
                    encoding = this.connection.getEncoding();
                }
                if (encoding != null) {
                    SingleByteCharsetConverter converter = null;
                    if (this.connection != null) {
                        converter = this.connection.getCharsetConverter(encoding);
                    }
                    if (converter != null) {
                        stringVal = converter.toString(this.buffer, stringStart, stringLength);
                    } else {
                        try {
                            stringVal = StringUtils.toString(this.buffer, stringStart, stringLength, encoding);
                        }
                        catch (UnsupportedEncodingException ue) {
                            throw new RuntimeException(Messages.getString("Field.12") + encoding + Messages.getString("Field.13"));
                        }
                    }
                } else {
                    stringVal = StringUtils.toAsciiString(this.buffer, stringStart, stringLength);
                }
            } else {
                stringVal = StringUtils.toAsciiString(this.buffer, stringStart, stringLength);
            }
        } else {
            stringVal = StringUtils.toAsciiString(this.buffer, stringStart, stringLength);
        }
        return stringVal;
    }

    public String getTable() throws SQLException {
        return this.getTableName();
    }

    public String getTableName() throws SQLException {
        if (this.tableName == null) {
            this.tableName = this.getStringFromBytes(this.tableNameStart, this.tableNameLength);
        }
        return this.tableName;
    }

    public String getTableNameNoAliases() throws SQLException {
        if (this.connection.versionMeetsMinimum(4, 1, 0)) {
            return this.getOriginalTableName();
        }
        return this.getTableName();
    }

    public boolean isAutoIncrement() {
        return (this.colFlag & 0x200) > 0;
    }

    public boolean isBinary() {
        return (this.colFlag & 0x80) > 0;
    }

    public boolean isBlob() {
        return (this.colFlag & 0x10) > 0;
    }

    private boolean isImplicitTemporaryTable() {
        return this.isImplicitTempTable;
    }

    public boolean isMultipleKey() {
        return (this.colFlag & 8) > 0;
    }

    boolean isNotNull() {
        return (this.colFlag & 1) > 0;
    }

    boolean isOpaqueBinary() throws SQLException {
        if (this.charsetIndex == 63 && this.isBinary() && (this.getGBaseType() == 254 || this.getGBaseType() == 253)) {
            if (this.originalTableNameLength == 0 && this.connection != null && !this.connection.versionMeetsMinimum(8, 2, 3)) {
                return false;
            }
            return !this.isImplicitTemporaryTable();
        }
        return this.connection.versionMeetsMinimum(4, 1, 0) && "binary".equalsIgnoreCase(this.getCharacterSet());
    }

    public boolean isPrimaryKey() {
        return (this.colFlag & 2) > 0;
    }

    boolean isReadOnly() throws SQLException {
        if (this.connection.versionMeetsMinimum(4, 1, 0)) {
            String orgColumnName = this.getOriginalName();
            String orgTableName = this.getOriginalTableName();
            return orgColumnName == null || orgColumnName.length() <= 0 || orgTableName == null || orgTableName.length() <= 0;
        }
        return false;
    }

    public boolean isUniqueKey() {
        return (this.colFlag & 4) > 0;
    }

    public boolean isUnsigned() {
        return (this.colFlag & 0x20) > 0;
    }

    public void setUnsigned() {
        this.colFlag = (short)(this.colFlag | 0x20);
    }

    public boolean isZeroFill() {
        return (this.colFlag & 0x40) > 0;
    }

    private void setBlobTypeBasedOnLength() {
        if (this.length == 255L) {
            this.gbaseType = 249;
        } else if (this.length == 65535L) {
            this.gbaseType = 252;
        } else if (this.length == 0xFFFFFFL) {
            this.gbaseType = 250;
        } else if (this.length == 0xFFFFFFFFL) {
            this.gbaseType = 251;
        }
    }

    private boolean isNativeNumericType() {
        return this.gbaseType >= 1 && this.gbaseType <= 5 || this.gbaseType == 8 || this.gbaseType == 13;
    }

    private boolean isNativeDateTimeType() {
        return this.gbaseType == 10 || this.gbaseType == 14 || this.gbaseType == 12 || this.gbaseType == 11 || this.gbaseType == 7;
    }

    public void setConnection(GBaseConnection conn) {
        this.connection = conn;
        if (this.charsetName == null || this.charsetIndex == 0) {
            this.charsetName = this.connection.getEncoding();
        }
    }

    void setGBaseType(int type) {
        this.gbaseType = type;
        this.sqlType = GBaseDefs.gbaseToJavaType(this.gbaseType);
    }

    protected void setUseOldNameMetadata(boolean useOldNameMetadata) {
        this.useOldNameMetadata = useOldNameMetadata;
    }

    public String toString() {
        try {
            StringBuffer asString = new StringBuffer();
            asString.append(super.toString());
            asString.append("[");
            asString.append("catalog=");
            asString.append(this.getDatabaseName());
            asString.append(",tableName=");
            asString.append(this.getTableName());
            asString.append(",originalTableName=");
            asString.append(this.getOriginalTableName());
            asString.append(",columnName=");
            asString.append(this.getName());
            asString.append(",originalColumnName=");
            asString.append(this.getOriginalName());
            asString.append(",gbaseType=");
            asString.append(this.getGBaseType());
            asString.append("(");
            asString.append(GBaseDefs.typeToName(this.getGBaseType()));
            asString.append(")");
            asString.append(",flags=");
            if (this.isAutoIncrement()) {
                asString.append(" AUTO_INCREMENT");
            }
            if (this.isPrimaryKey()) {
                asString.append(" PRIMARY_KEY");
            }
            if (this.isUniqueKey()) {
                asString.append(" UNIQUE_KEY");
            }
            if (this.isBinary()) {
                asString.append(" BINARY");
            }
            if (this.isBlob()) {
                asString.append(" BLOB");
            }
            if (this.isMultipleKey()) {
                asString.append(" MULTI_KEY");
            }
            if (this.isUnsigned()) {
                asString.append(" UNSIGNED");
            }
            if (this.isZeroFill()) {
                asString.append(" ZEROFILL");
            }
            asString.append(", charsetIndex=");
            asString.append(this.charsetIndex);
            asString.append(", charsetName=");
            asString.append(this.charsetName);
            asString.append("]");
            return asString.toString();
        }
        catch (Throwable t) {
            return super.toString();
        }
    }

    protected boolean isSingleBit() {
        return this.isSingleBit;
    }
}

