/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.Messages;
import com.gbase.jdbc.SQLError;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GcGBaseLoadBalanceQueue {
    private String gclusterId;
    private ConcurrentLinkedQueue niceQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue brokenQueue = new ConcurrentLinkedQueue();
    private Properties props;
    private String originalUrl = null;

    public GcGBaseLoadBalanceQueue(String gclusterId, Properties props, String originalUrl) {
        this.gclusterId = gclusterId;
        this.originalUrl = originalUrl;
        this.props = (Properties)props.clone();
    }

    public void initNiceQueueByList(List ipList) throws SQLException {
        if (ipList == null || ipList.isEmpty()) {
            throw SQLError.createSQLException(Messages.getString("GcGBaseLoadBalance.Connection.ipList", new Object[]{this.gclusterId}), "GclusterLoadBalance", null);
        }
        this.niceQueue.addAll(ipList);
    }

    public ConcurrentLinkedQueue getNiceQueue() {
        return this.niceQueue;
    }

    public void setNiceQueue(ConcurrentLinkedQueue niceQueue) {
        this.niceQueue = niceQueue;
    }

    public ConcurrentLinkedQueue getBrokenQueue() {
        return this.brokenQueue;
    }

    public void setBrokenQueue(ConcurrentLinkedQueue brokenQueue) {
        this.brokenQueue = brokenQueue;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public void setOriginalUrl(String originalUrl) {
        this.originalUrl = originalUrl;
    }
}

