/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.CommunicationsException;
import com.gbase.jdbc.Connection;
import com.gbase.jdbc.Constants;
import com.gbase.jdbc.ExceptionInterceptor;
import com.gbase.jdbc.GBaseConnection;
import com.gbase.jdbc.GBaseDataTruncation;
import com.gbase.jdbc.GBaseErrorNumbers;
import com.gbase.jdbc.Messages;
import com.gbase.jdbc.NotImplemented;
import com.gbase.jdbc.Util;
import com.gbase.jdbc.exceptions.GBaseDataException;
import com.gbase.jdbc.exceptions.GBaseIntegrityConstraintViolationException;
import com.gbase.jdbc.exceptions.GBaseNonTransientConnectionException;
import com.gbase.jdbc.exceptions.GBaseQueryInterruptedException;
import com.gbase.jdbc.exceptions.GBaseSyntaxErrorException;
import com.gbase.jdbc.exceptions.GBaseTransactionRollbackException;
import com.gbase.jdbc.exceptions.GBaseTransientConnectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.BindException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;

public class SQLError {
    static final int ER_WARNING_NOT_COMPLETE_ROLLBACK = 1196;
    private static Map gbaseToSql99State;
    private static Map gbaseToSqlState;
    public static final String SQL_STATE_BASE_TABLE_NOT_FOUND = "S0002";
    public static final String SQL_STATE_BASE_TABLE_OR_VIEW_ALREADY_EXISTS = "S0001";
    public static final String SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND = "42S02";
    public static final String SQL_STATE_COLUMN_ALREADY_EXISTS = "S0021";
    public static final String SQL_STATE_COLUMN_NOT_FOUND = "S0022";
    public static final String SQL_STATE_COMMUNICATION_LINK_FAILURE = "08S01";
    public static final String SQL_STATE_CONNECTION_FAIL_DURING_TX = "08007";
    public static final String SQL_STATE_CONNECTION_IN_USE = "08002";
    public static final String SQL_STATE_CONNECTION_NOT_OPEN = "08003";
    public static final String SQL_STATE_CONNECTION_REJECTED = "08004";
    public static final String SQL_STATE_DATE_TRUNCATED = "01004";
    public static final String SQL_STATE_DATETIME_FIELD_OVERFLOW = "22008";
    public static final String SQL_STATE_DEADLOCK = "41000";
    public static final String SQL_STATE_DISCONNECT_ERROR = "01002";
    public static final String SQL_STATE_DIVISION_BY_ZERO = "22012";
    public static final String SQL_STATE_DRIVER_NOT_CAPABLE = "S1C00";
    public static final String SQL_STATE_ERROR_IN_ROW = "01S01";
    public static final String SQL_STATE_GENERAL_ERROR = "S1000";
    public static final String SQL_STATE_ILLEGAL_ARGUMENT = "S1009";
    public static final String SQL_STATE_INDEX_ALREADY_EXISTS = "S0011";
    public static final String SQL_STATE_INDEX_NOT_FOUND = "S0012";
    public static final String SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST = "21S01";
    public static final String SQL_STATE_INVALID_AUTH_SPEC = "28000";
    public static final String SQL_STATE_INVALID_CHARACTER_VALUE_FOR_CAST = "22018";
    public static final String SQL_STATE_INVALID_COLUMN_NUMBER = "S1002";
    public static final String SQL_STATE_INVALID_CONNECTION_ATTRIBUTE = "01S00";
    public static final String SQL_STATE_MEMORY_ALLOCATION_FAILURE = "S1001";
    public static final String SQL_STATE_MORE_THAN_ONE_ROW_UPDATED_OR_DELETED = "01S04";
    public static final String SQL_STATE_NO_DEFAULT_FOR_COLUMN = "S0023";
    public static final String SQL_STATE_NO_ROWS_UPDATED_OR_DELETED = "01S03";
    public static final String SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE = "22003";
    public static final String SQL_STATE_PRIVILEGE_NOT_REVOKED = "01006";
    public static final String SQL_STATE_SYNTAX_ERROR = "42000";
    public static final String SQL_STATE_TIMEOUT_EXPIRED = "S1T00";
    public static final String SQL_STATE_TRANSACTION_RESOLUTION_UNKNOWN = "08007";
    public static final String SQL_STATE_UNABLE_TO_CONNECT_TO_DATASOURCE = "08001";
    public static final String SQL_STATE_WRONG_NO_OF_PARAMETERS = "07001";
    public static final String SQL_STATE_INVALID_TRANSACTION_TERMINATION = "2D000";
    private static Map sqlStateMessages;
    private static final long DEFAULT_WAIT_TIMEOUT_SECONDS = 28800L;
    private static final int DUE_TO_TIMEOUT_FALSE = 0;
    private static final int DUE_TO_TIMEOUT_MAYBE = 2;
    private static final int DUE_TO_TIMEOUT_TRUE = 1;
    private static final Constructor JDBC_4_COMMUNICATIONS_EXCEPTION_CTOR;
    private static Method THROWABLE_INIT_CAUSE_METHOD;

    static SQLWarning convertShowWarningsToSQLWarnings(Connection connection) throws SQLException {
        return SQLError.convertShowWarningsToSQLWarnings(connection, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SQLWarning convertShowWarningsToSQLWarnings(Connection connection, int warningCountIfKnown, boolean forTruncationOnly) throws SQLException {
        SQLException sqlEx22;
        SQLException reThrow2;
        GBaseDataTruncation gBaseDataTruncation;
        Statement stmt;
        block21: {
            stmt = null;
            ResultSet warnRs = null;
            SQLWarning currentWarning = null;
            try {
                if (warningCountIfKnown < 100) {
                    stmt = connection.createStatement();
                    if (stmt.getMaxRows() != 0) {
                        stmt.setMaxRows(0);
                    }
                } else {
                    stmt = connection.createStatement(1003, 1007);
                    stmt.setFetchSize(Integer.MIN_VALUE);
                }
                warnRs = stmt.executeQuery("SHOW WARNINGS");
                while (warnRs.next()) {
                    int code = warnRs.getInt("Code");
                    if (forTruncationOnly) {
                        if (code != 1265 && code != 1264) continue;
                        GBaseDataTruncation newTruncation = new GBaseDataTruncation(warnRs.getString("Message"), 0, false, false, 0, 0, code);
                        if (currentWarning == null) {
                            currentWarning = newTruncation;
                            continue;
                        }
                        currentWarning.setNextWarning(newTruncation);
                        continue;
                    }
                    String level = warnRs.getString("Level");
                    String message = warnRs.getString("Message");
                    SQLWarning newWarning = new SQLWarning(message, SQLError.gbaseToSqlState(code, connection.getUseSqlStateCodes()), code);
                    if (currentWarning == null) {
                        currentWarning = newWarning;
                        continue;
                    }
                    currentWarning.setNextWarning(newWarning);
                }
                if (forTruncationOnly && currentWarning != null) {
                    throw currentWarning;
                }
                gBaseDataTruncation = currentWarning;
                Object var11_11 = null;
                reThrow2 = null;
                if (warnRs == null) break block21;
            }
            catch (Throwable throwable) {
                SQLException sqlEx22;
                Object var11_12 = null;
                SQLException reThrow2 = null;
                if (warnRs != null) {
                    try {
                        warnRs.close();
                    }
                    catch (SQLException sqlEx22) {
                        reThrow2 = sqlEx22;
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlEx22) {
                        reThrow2 = sqlEx22;
                    }
                }
                if (reThrow2 != null) {
                    throw reThrow2;
                }
                throw throwable;
            }
            try {
                warnRs.close();
            }
            catch (SQLException sqlEx22) {
                reThrow2 = sqlEx22;
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sqlEx22) {
                reThrow2 = sqlEx22;
            }
        }
        if (reThrow2 != null) {
            throw reThrow2;
        }
        return gBaseDataTruncation;
    }

    public static void dumpSqlStatesMappingsAsXml() throws Exception {
        TreeMap<Integer, Integer> allErrorNumbers = new TreeMap<Integer, Integer>();
        HashMap<Object, String> gbaseErrorNumbersToNames = new HashMap<Object, String>();
        Integer errorNumber2 = null;
        for (Integer errorNumber2 : gbaseToSql99State.keySet()) {
            allErrorNumbers.put(errorNumber2, errorNumber2);
        }
        for (Integer errorNumber2 : gbaseToSqlState.keySet()) {
            allErrorNumbers.put(errorNumber2, errorNumber2);
        }
        Field[] possibleFields = GBaseErrorNumbers.class.getDeclaredFields();
        for (int i = 0; i < possibleFields.length; ++i) {
            String fieldName = possibleFields[i].getName();
            if (!fieldName.startsWith("ER_")) continue;
            gbaseErrorNumbersToNames.put(possibleFields[i].get(null), fieldName);
        }
        System.out.println("<ErrorMappings>");
        for (Integer errorNumber2 : allErrorNumbers.keySet()) {
            String sql92State = SQLError.gbaseToSql99(errorNumber2);
            String oldSqlState = SQLError.gbaseToXOpen(errorNumber2);
            System.out.println("   <ErrorMapping gbaseErrorNumber=\"" + errorNumber2 + "\" gbaseErrorName=\"" + gbaseErrorNumbersToNames.get(errorNumber2) + "\" legacySqlState=\"" + (oldSqlState == null ? "" : oldSqlState) + "\" sql92SqlState=\"" + (sql92State == null ? "" : sql92State) + "\"/>");
        }
        System.out.println("</ErrorMappings>");
    }

    static String get(String stateCode) {
        return (String)sqlStateMessages.get(stateCode);
    }

    private static String gbaseToSql99(int errno) {
        Integer err = Constants.integerValueOf(errno);
        if (gbaseToSql99State.containsKey(err)) {
            return (String)gbaseToSql99State.get(err);
        }
        return "HY000";
    }

    static String gbaseToSqlState(int errno, boolean useSql92States) {
        if (useSql92States) {
            return SQLError.gbaseToSql99(errno);
        }
        return SQLError.gbaseToXOpen(errno);
    }

    private static String gbaseToXOpen(int errno) {
        Integer err = Constants.integerValueOf(errno);
        if (gbaseToSqlState.containsKey(err)) {
            return (String)gbaseToSqlState.get(err);
        }
        return SQL_STATE_GENERAL_ERROR;
    }

    public static SQLException createSQLException(String message, String sqlState, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, sqlState, 0, interceptor);
    }

    public static SQLException createSQLException(String message, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, interceptor, null);
    }

    public static SQLException createSQLException(String message, ExceptionInterceptor interceptor, Connection conn) {
        SQLException interceptedEx;
        SQLException sqlEx = new SQLException(message);
        if (interceptor != null && (interceptedEx = interceptor.interceptException(sqlEx, conn)) != null) {
            return interceptedEx;
        }
        return sqlEx;
    }

    public static SQLException createSQLException(String message, String sqlState, Throwable cause, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, sqlState, cause, interceptor, null);
    }

    public static SQLException createSQLException(String message, String sqlState, Throwable cause, ExceptionInterceptor interceptor, Connection conn) {
        SQLException interceptedEx;
        if (THROWABLE_INIT_CAUSE_METHOD == null && cause != null) {
            message = message + " due to " + cause.toString();
        }
        SQLException sqlEx = SQLError.createSQLException(message, sqlState, interceptor);
        if (cause != null && THROWABLE_INIT_CAUSE_METHOD != null) {
            try {
                THROWABLE_INIT_CAUSE_METHOD.invoke((Object)sqlEx, cause);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (interceptor != null && (interceptedEx = interceptor.interceptException(sqlEx, conn)) != null) {
            return interceptedEx;
        }
        return sqlEx;
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, sqlState, vendorErrorCode, false, interceptor);
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, boolean isTransient, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, sqlState, vendorErrorCode, false, interceptor, null);
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, boolean isTransient, ExceptionInterceptor interceptor, Connection conn) {
        try {
            SQLException interceptedEx;
            SQLException sqlEx = null;
            sqlEx = sqlState != null ? (sqlState.startsWith("08") ? (isTransient ? (!Util.isJdbc4() ? new GBaseTransientConnectionException(message, sqlState, vendorErrorCode) : (SQLException)Util.getInstance("com.gbase.jdbc.exceptions.jdbc4.GBaseTransientConnectionException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, Constants.integerValueOf(vendorErrorCode)}, interceptor)) : (!Util.isJdbc4() ? new GBaseNonTransientConnectionException(message, sqlState, vendorErrorCode) : (SQLException)Util.getInstance("com.gbase.jdbc.exceptions.jdbc4.GBaseNonTransientConnectionException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, Constants.integerValueOf(vendorErrorCode)}, interceptor))) : (sqlState.startsWith("22") ? (!Util.isJdbc4() ? new GBaseDataException(message, sqlState, vendorErrorCode) : (SQLException)Util.getInstance("com.gbase.jdbc.exceptions.jdbc4.GBaseDataException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, Constants.integerValueOf(vendorErrorCode)}, interceptor)) : (sqlState.startsWith("23") ? (!Util.isJdbc4() ? new GBaseIntegrityConstraintViolationException(message, sqlState, vendorErrorCode) : (SQLException)Util.getInstance("com.gbase.jdbc.exceptions.jdbc4.GBaseIntegrityConstraintViolationException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, Constants.integerValueOf(vendorErrorCode)}, interceptor)) : (sqlState.startsWith("42") ? (!Util.isJdbc4() ? new GBaseSyntaxErrorException(message, sqlState, vendorErrorCode) : (SQLException)Util.getInstance("com.gbase.jdbc.exceptions.jdbc4.GBaseSyntaxErrorException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, Constants.integerValueOf(vendorErrorCode)}, interceptor)) : (sqlState.startsWith("40") ? (!Util.isJdbc4() ? new GBaseTransactionRollbackException(message, sqlState, vendorErrorCode) : (SQLException)Util.getInstance("com.gbase.jdbc.exceptions.jdbc4.GBaseTransactionRollbackException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, Constants.integerValueOf(vendorErrorCode)}, interceptor)) : (sqlState.startsWith("70100") ? (!Util.isJdbc4() ? new GBaseQueryInterruptedException(message, sqlState, vendorErrorCode) : (SQLException)Util.getInstance("com.gbase.jdbc.exceptions.jdbc4.GBaseQueryInterruptedException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, vendorErrorCode}, interceptor)) : new SQLException(message, sqlState, vendorErrorCode))))))) : new SQLException(message, sqlState, vendorErrorCode);
            if (interceptor != null && (interceptedEx = interceptor.interceptException(sqlEx, conn)) != null) {
                return interceptedEx;
            }
            return sqlEx;
        }
        catch (SQLException sqlEx) {
            SQLException interceptedEx;
            SQLException unexpectedEx = new SQLException("Unable to create correct SQLException class instance, error class/codes may be incorrect. Reason: " + Util.stackTraceToString(sqlEx), SQL_STATE_GENERAL_ERROR);
            if (interceptor != null && (interceptedEx = interceptor.interceptException(unexpectedEx, conn)) != null) {
                return interceptedEx;
            }
            return unexpectedEx;
        }
    }

    public static SQLException createCommunicationsException(GBaseConnection conn, long lastPacketSentTimeMs, long lastPacketReceivedTimeMs, Exception underlyingException, ExceptionInterceptor interceptor) {
        SQLException interceptedEx;
        SQLException exToReturn = null;
        if (!Util.isJdbc4()) {
            exToReturn = new CommunicationsException(conn, lastPacketSentTimeMs, lastPacketReceivedTimeMs, underlyingException);
        } else {
            try {
                exToReturn = (SQLException)Util.handleNewInstance(JDBC_4_COMMUNICATIONS_EXCEPTION_CTOR, new Object[]{conn, Constants.longValueOf(lastPacketSentTimeMs), Constants.longValueOf(lastPacketReceivedTimeMs), underlyingException}, interceptor);
            }
            catch (SQLException sqlEx) {
                return sqlEx;
            }
        }
        if (THROWABLE_INIT_CAUSE_METHOD != null && underlyingException != null) {
            try {
                THROWABLE_INIT_CAUSE_METHOD.invoke((Object)exToReturn, underlyingException);
            }
            catch (Throwable sqlEx) {
                // empty catch block
            }
        }
        if (interceptor != null && (interceptedEx = interceptor.interceptException(exToReturn, conn)) != null) {
            return interceptedEx;
        }
        return exToReturn;
    }

    public static String createLinkFailureMessageBasedOnHeuristics(GBaseConnection conn, long lastPacketSentTimeMs, long lastPacketReceivedTimeMs, Exception underlyingException, boolean streamingResultSetInPlay) {
        Object[] timingInfo;
        long serverTimeoutSeconds = 0L;
        boolean isInteractiveClient = false;
        if (conn != null) {
            isInteractiveClient = conn.getInteractiveClient();
            String serverTimeoutSecondsStr = null;
            serverTimeoutSecondsStr = isInteractiveClient ? conn.getServerVariable("interactive_timeout") : conn.getServerVariable("wait_timeout");
            if (serverTimeoutSecondsStr != null) {
                try {
                    serverTimeoutSeconds = Long.parseLong(serverTimeoutSecondsStr);
                }
                catch (NumberFormatException nfe) {
                    serverTimeoutSeconds = 0L;
                }
            }
        }
        StringBuffer exceptionMessageBuf = new StringBuffer();
        if (lastPacketSentTimeMs == 0L) {
            lastPacketSentTimeMs = System.currentTimeMillis();
        }
        long timeSinceLastPacket = (System.currentTimeMillis() - lastPacketSentTimeMs) / 1000L;
        long timeSinceLastPacketMs = System.currentTimeMillis() - lastPacketSentTimeMs;
        long timeSinceLastPacketReceivedMs = System.currentTimeMillis() - lastPacketReceivedTimeMs;
        int dueToTimeout = 0;
        StringBuffer timeoutMessageBuf = null;
        if (streamingResultSetInPlay) {
            exceptionMessageBuf.append(Messages.getString("CommunicationsException.ClientWasStreaming"));
        } else {
            if (serverTimeoutSeconds != 0L) {
                if (timeSinceLastPacket > serverTimeoutSeconds) {
                    dueToTimeout = 1;
                    timeoutMessageBuf = new StringBuffer();
                    timeoutMessageBuf.append(Messages.getString("CommunicationsException.2"));
                    if (!isInteractiveClient) {
                        timeoutMessageBuf.append(Messages.getString("CommunicationsException.3"));
                    } else {
                        timeoutMessageBuf.append(Messages.getString("CommunicationsException.4"));
                    }
                }
            } else if (timeSinceLastPacket > 28800L) {
                dueToTimeout = 2;
                timeoutMessageBuf = new StringBuffer();
                timeoutMessageBuf.append(Messages.getString("CommunicationsException.5"));
                timeoutMessageBuf.append(Messages.getString("CommunicationsException.6"));
                timeoutMessageBuf.append(Messages.getString("CommunicationsException.7"));
                timeoutMessageBuf.append(Messages.getString("CommunicationsException.8"));
            }
            if (dueToTimeout == 1 || dueToTimeout == 2) {
                if (lastPacketReceivedTimeMs != 0L) {
                    timingInfo = new Object[]{new Long(timeSinceLastPacketReceivedMs), new Long(timeSinceLastPacketMs)};
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.ServerPacketTimingInfo", timingInfo));
                } else {
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.ServerPacketTimingInfoNoRecv", new Object[]{new Long(timeSinceLastPacketMs)}));
                }
                if (timeoutMessageBuf != null) {
                    exceptionMessageBuf.append(timeoutMessageBuf);
                }
                exceptionMessageBuf.append(Messages.getString("CommunicationsException.11"));
                exceptionMessageBuf.append(Messages.getString("CommunicationsException.12"));
                exceptionMessageBuf.append(Messages.getString("CommunicationsException.13"));
            } else if (underlyingException instanceof BindException) {
                if (conn.getLocalSocketAddress() != null && !Util.interfaceExists(conn.getLocalSocketAddress())) {
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.LocalSocketAddressNotAvailable"));
                } else {
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.TooManyClientConnections"));
                }
            }
        }
        if (exceptionMessageBuf.length() == 0) {
            exceptionMessageBuf.append(Messages.getString("CommunicationsException.20"));
            if (THROWABLE_INIT_CAUSE_METHOD == null && underlyingException != null) {
                exceptionMessageBuf.append(Messages.getString("CommunicationsException.21"));
                exceptionMessageBuf.append(Util.stackTraceToString(underlyingException));
            }
            if (conn != null && conn.getMaintainTimeStats() && !conn.getParanoid()) {
                exceptionMessageBuf.append("\n\n");
                if (lastPacketReceivedTimeMs != 0L) {
                    timingInfo = new Object[]{new Long(timeSinceLastPacketReceivedMs), new Long(timeSinceLastPacketMs)};
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.ServerPacketTimingInfo", timingInfo));
                } else {
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.ServerPacketTimingInfoNoRecv", new Object[]{new Long(timeSinceLastPacketMs)}));
                }
            }
        }
        return exceptionMessageBuf.toString();
    }

    public static SQLException notImplemented() {
        if (Util.isJdbc4()) {
            try {
                return (SQLException)Class.forName("java.sql.SQLFeatureNotSupportedException").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new NotImplemented();
    }

    static {
        if (Util.isJdbc4()) {
            try {
                JDBC_4_COMMUNICATIONS_EXCEPTION_CTOR = Class.forName("com.gbase.jdbc.exceptions.jdbc4.CommunicationsException").getConstructor(GBaseConnection.class, Long.TYPE, Long.TYPE, Exception.class);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            JDBC_4_COMMUNICATIONS_EXCEPTION_CTOR = null;
        }
        try {
            THROWABLE_INIT_CAUSE_METHOD = Throwable.class.getMethod("initCause", Throwable.class);
        }
        catch (Throwable t) {
            THROWABLE_INIT_CAUSE_METHOD = null;
        }
        sqlStateMessages = new HashMap();
        sqlStateMessages.put(SQL_STATE_DISCONNECT_ERROR, Messages.getString("SQLError.35"));
        sqlStateMessages.put(SQL_STATE_DATE_TRUNCATED, Messages.getString("SQLError.36"));
        sqlStateMessages.put(SQL_STATE_PRIVILEGE_NOT_REVOKED, Messages.getString("SQLError.37"));
        sqlStateMessages.put(SQL_STATE_INVALID_CONNECTION_ATTRIBUTE, Messages.getString("SQLError.38"));
        sqlStateMessages.put(SQL_STATE_ERROR_IN_ROW, Messages.getString("SQLError.39"));
        sqlStateMessages.put(SQL_STATE_NO_ROWS_UPDATED_OR_DELETED, Messages.getString("SQLError.40"));
        sqlStateMessages.put(SQL_STATE_MORE_THAN_ONE_ROW_UPDATED_OR_DELETED, Messages.getString("SQLError.41"));
        sqlStateMessages.put(SQL_STATE_WRONG_NO_OF_PARAMETERS, Messages.getString("SQLError.42"));
        sqlStateMessages.put(SQL_STATE_UNABLE_TO_CONNECT_TO_DATASOURCE, Messages.getString("SQLError.43"));
        sqlStateMessages.put(SQL_STATE_CONNECTION_IN_USE, Messages.getString("SQLError.44"));
        sqlStateMessages.put(SQL_STATE_CONNECTION_NOT_OPEN, Messages.getString("SQLError.45"));
        sqlStateMessages.put(SQL_STATE_CONNECTION_REJECTED, Messages.getString("SQLError.46"));
        sqlStateMessages.put("08007", Messages.getString("SQLError.47"));
        sqlStateMessages.put(SQL_STATE_COMMUNICATION_LINK_FAILURE, Messages.getString("SQLError.48"));
        sqlStateMessages.put(SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST, Messages.getString("SQLError.49"));
        sqlStateMessages.put(SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE, Messages.getString("SQLError.50"));
        sqlStateMessages.put(SQL_STATE_DATETIME_FIELD_OVERFLOW, Messages.getString("SQLError.51"));
        sqlStateMessages.put(SQL_STATE_DIVISION_BY_ZERO, Messages.getString("SQLError.52"));
        sqlStateMessages.put(SQL_STATE_DEADLOCK, Messages.getString("SQLError.53"));
        sqlStateMessages.put(SQL_STATE_INVALID_AUTH_SPEC, Messages.getString("SQLError.54"));
        sqlStateMessages.put(SQL_STATE_SYNTAX_ERROR, Messages.getString("SQLError.55"));
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND, Messages.getString("SQLError.56"));
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_OR_VIEW_ALREADY_EXISTS, Messages.getString("SQLError.57"));
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_NOT_FOUND, Messages.getString("SQLError.58"));
        sqlStateMessages.put(SQL_STATE_INDEX_ALREADY_EXISTS, Messages.getString("SQLError.59"));
        sqlStateMessages.put(SQL_STATE_INDEX_NOT_FOUND, Messages.getString("SQLError.60"));
        sqlStateMessages.put(SQL_STATE_COLUMN_ALREADY_EXISTS, Messages.getString("SQLError.61"));
        sqlStateMessages.put(SQL_STATE_COLUMN_NOT_FOUND, Messages.getString("SQLError.62"));
        sqlStateMessages.put(SQL_STATE_NO_DEFAULT_FOR_COLUMN, Messages.getString("SQLError.63"));
        sqlStateMessages.put(SQL_STATE_GENERAL_ERROR, Messages.getString("SQLError.64"));
        sqlStateMessages.put(SQL_STATE_MEMORY_ALLOCATION_FAILURE, Messages.getString("SQLError.65"));
        sqlStateMessages.put(SQL_STATE_INVALID_COLUMN_NUMBER, Messages.getString("SQLError.66"));
        sqlStateMessages.put(SQL_STATE_ILLEGAL_ARGUMENT, Messages.getString("SQLError.67"));
        sqlStateMessages.put(SQL_STATE_DRIVER_NOT_CAPABLE, Messages.getString("SQLError.68"));
        sqlStateMessages.put(SQL_STATE_TIMEOUT_EXPIRED, Messages.getString("SQLError.69"));
        gbaseToSqlState = new Hashtable();
        gbaseToSqlState.put(Constants.integerValueOf(1040), SQL_STATE_CONNECTION_REJECTED);
        gbaseToSqlState.put(Constants.integerValueOf(1042), SQL_STATE_CONNECTION_REJECTED);
        gbaseToSqlState.put(Constants.integerValueOf(1043), SQL_STATE_CONNECTION_REJECTED);
        gbaseToSqlState.put(Constants.integerValueOf(1047), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSqlState.put(Constants.integerValueOf(1081), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSqlState.put(Constants.integerValueOf(1129), SQL_STATE_CONNECTION_REJECTED);
        gbaseToSqlState.put(Constants.integerValueOf(1130), SQL_STATE_CONNECTION_REJECTED);
        gbaseToSqlState.put(Constants.integerValueOf(1045), SQL_STATE_INVALID_AUTH_SPEC);
        gbaseToSqlState.put(Constants.integerValueOf(1037), SQL_STATE_MEMORY_ALLOCATION_FAILURE);
        gbaseToSqlState.put(Constants.integerValueOf(1038), SQL_STATE_MEMORY_ALLOCATION_FAILURE);
        gbaseToSqlState.put(Constants.integerValueOf(1064), SQL_STATE_SYNTAX_ERROR);
        gbaseToSqlState.put(Constants.integerValueOf(1065), SQL_STATE_SYNTAX_ERROR);
        gbaseToSqlState.put(Constants.integerValueOf(1055), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1056), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1057), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1059), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1060), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1061), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1062), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1063), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1066), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1067), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1068), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1069), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1070), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1071), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1072), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1073), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1074), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1075), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1082), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1083), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1084), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1058), SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        gbaseToSqlState.put(Constants.integerValueOf(1051), SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        gbaseToSqlState.put(Constants.integerValueOf(1054), SQL_STATE_COLUMN_NOT_FOUND);
        gbaseToSqlState.put(Constants.integerValueOf(1205), SQL_STATE_DEADLOCK);
        gbaseToSqlState.put(Constants.integerValueOf(1213), SQL_STATE_DEADLOCK);
        gbaseToSql99State = new HashMap();
        gbaseToSql99State.put(Constants.integerValueOf(1205), SQL_STATE_DEADLOCK);
        gbaseToSql99State.put(Constants.integerValueOf(1213), SQL_STATE_DEADLOCK);
        gbaseToSql99State.put(Constants.integerValueOf(1022), "23000");
        gbaseToSql99State.put(Constants.integerValueOf(1037), "HY001");
        gbaseToSql99State.put(Constants.integerValueOf(1038), "HY001");
        gbaseToSql99State.put(Constants.integerValueOf(1040), SQL_STATE_CONNECTION_REJECTED);
        gbaseToSql99State.put(Constants.integerValueOf(1042), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1043), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1044), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1045), SQL_STATE_INVALID_AUTH_SPEC);
        gbaseToSql99State.put(Constants.integerValueOf(1050), "42S01");
        gbaseToSql99State.put(Constants.integerValueOf(1051), SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        gbaseToSql99State.put(Constants.integerValueOf(1052), "23000");
        gbaseToSql99State.put(Constants.integerValueOf(1053), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1054), "42S22");
        gbaseToSql99State.put(Constants.integerValueOf(1055), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1056), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1057), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1058), SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        gbaseToSql99State.put(Constants.integerValueOf(1059), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1060), "42S21");
        gbaseToSql99State.put(Constants.integerValueOf(1061), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1062), "23000");
        gbaseToSql99State.put(Constants.integerValueOf(1063), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1064), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1065), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1066), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1067), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1068), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1069), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1070), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1071), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1072), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1073), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1074), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1075), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1080), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1081), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1082), "42S12");
        gbaseToSql99State.put(Constants.integerValueOf(1083), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1084), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1090), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1091), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1101), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1102), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1103), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1104), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1106), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1107), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1109), SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        gbaseToSql99State.put(Constants.integerValueOf(1110), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1112), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1113), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1115), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1118), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1120), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1121), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1131), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1132), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1133), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1136), SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        gbaseToSql99State.put(Constants.integerValueOf(1138), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1139), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1140), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1141), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1142), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1143), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1144), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1145), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1146), SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        gbaseToSql99State.put(Constants.integerValueOf(1147), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1148), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1149), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1152), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1153), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1154), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1155), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1156), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1157), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1158), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1159), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1160), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1161), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1162), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1163), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1164), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1166), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1167), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1169), "23000");
        gbaseToSql99State.put(Constants.integerValueOf(1170), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1171), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1172), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1173), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1177), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1178), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1179), "25000");
        gbaseToSql99State.put(Constants.integerValueOf(1184), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1189), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1190), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1203), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1207), "25000");
        gbaseToSql99State.put(Constants.integerValueOf(1211), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1213), "40001");
        gbaseToSql99State.put(Constants.integerValueOf(1216), "23000");
        gbaseToSql99State.put(Constants.integerValueOf(1217), "23000");
        gbaseToSql99State.put(Constants.integerValueOf(1218), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1222), "21000");
        gbaseToSql99State.put(Constants.integerValueOf(1226), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1230), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1231), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1232), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1234), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1235), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1239), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1241), "21000");
        gbaseToSql99State.put(Constants.integerValueOf(1242), "21000");
        gbaseToSql99State.put(Constants.integerValueOf(1247), "42S22");
        gbaseToSql99State.put(Constants.integerValueOf(1248), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1249), "01000");
        gbaseToSql99State.put(Constants.integerValueOf(1250), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1251), SQL_STATE_CONNECTION_REJECTED);
        gbaseToSql99State.put(Constants.integerValueOf(1252), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1253), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1261), "01000");
        gbaseToSql99State.put(Constants.integerValueOf(1262), "01000");
        gbaseToSql99State.put(Constants.integerValueOf(1263), "01000");
        gbaseToSql99State.put(Constants.integerValueOf(1264), "01000");
        gbaseToSql99State.put(Constants.integerValueOf(1265), "01000");
        gbaseToSql99State.put(Constants.integerValueOf(1280), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1281), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1286), SQL_STATE_SYNTAX_ERROR);
    }
}

